<?php
session_start();
include('data/data.php');
setlocale(LC_TIME, 'fr_FR', 'fra');

function convertDate($date)
{
    $formatter = new IntlDateFormatter('fr_FR', IntlDateFormatter::LONG, IntlDateFormatter::NONE);
    $conv = date_create($date);
    return $formatter->format($conv);
}

function convertTS($ts)
{
    return date("Ymd", $ts);
}

function convertTSF($ts)
{
    return date("d/m/Y", $ts);
}

if (isset($_SESSION['maid']) && isset($_SESSION['log'])) {

    $pdf = '';

    $dayref = new DateTime("now");
    $dayref = $dayref->modify('-1 day');
    $today = $dayref->getTimestamp(); // Timestamp du jour + 1 jour
    $year = '';
    $month = '';
    $newyear = 0;
    $newmonth = 0;
    $i = 0;

    $query = $sql->run('SELECT property,rent,start,end,caution,firstname,lastname,phone,email,adult,child,accueil, statut FROM booking WHERE end>' . $today . ' AND statut IN(1,2,3) ORDER BY start ASC');

    $pdf .= '<h1 class="arial fs2 mt0 mb3 txtcenter cyan2">Réservations en cours</h1>';
    $pdf .= '<table id="pdfLIst" class="w100 arial fs13">';
    $pdf .= '<thead>
            <tr class="bglightgrey">
                <th class="pa1 bold">Location</th>
                <th class="pa1 bold">Type</th>
                <th class="pa1 bold">Check In</th>
                <th class="pa1 bold">Check Out</th>
                <th class="pa1 bold">Locataire</th>
                <th class="pa1 bold">Contact</th>
                <th class="pa1 bold">Caution</th>
                <th class="pa1 bold">Consignes</th>
            </tr>
            </thead><tbody>';

    while ($r = $query->fetch()) {

        if ($i % 2 == 1) {
            $css = 'bgf2';
        } else {
            $css = '';
        }

        $start = convertTSF($r['start']);
        $end = convertTSF($r['end']);
        $phone = chunk_split($r['phone'], 2, ' ');

        $adult = 'adulte';
        $child = 'enfant';

        if ($r['adult'] > 1) {
            $adult = 'adultes';
        }

        if ($r['child'] > 1) {
            $child = 'enfants';
        }

        $statut = '';

        switch ($r['statut']) {
            case 1:
                $statut = 'O';
                $color = 'bly';
                break;
            case 2:
                $statut = 'R';
                $color = 'blg';
                break;
            case 3:
                $statut = 'M';
                $color = 'blb';
                break;
        }

        $pdf .= '<tr>
        <td class="pa1 rel bold">' . $r['rent'] . '</td>
        <td class="pa1 txtcenter ' . $color . '">' . $statut . '</td>
        <td class="pa1 arial bold">' . $start . '</td>
        <td class="pa1 arial bold">' . $end . '</td>
        <td class="pa1"><span class="bold">' . $r['firstname'] . ' ' . $r['lastname'] . '</span><br />' . $r['adult'] . ' ' . $adult . ' + ' . $r['child'] . ' ' . $child . '</td>
        <td class="pa1 arial"><span class="bold">' . $phone . '</span><br />' . $r['email'] . '</td>
        <td class="pa1 arial">' . $r['caution'] . '</td>
        <td class="pa1 arial">' . $r['accueil'] . '</td>
    </tr>';
    }
    $pdf .= '</tbody>
</table>';

    require_once __DIR__ . '/vendor/autoload.php';
    $mpdf = new \Mpdf\Mpdf(['debug' => true, 'mode' => 'utf-8', 'format' => 'A4-L']);
    $stylesheet = file_get_contents('css/pdf.css');
    $mpdf->setFooter('{PAGENO}');
    $mpdf->WriteHTML($stylesheet, 1);
    $mpdf->WriteHTML($pdf, 2);
    $mpdf->Output('Réservations.pdf', \Mpdf\Output\Destination::INLINE);
    exit;
} else {
    header("Location: $domain.concierge");
    exit;
}
