<?php
require_once('data/functions.php');

$pdf = '';
$prop = '';
$rent = '';
$currentYear = substr($page, -4);

$allYear = array();
$totLoyers = array();
$sumLoyers = 0;
$loyerTotal = 0;
$loyerGlobal = 0;
$i = 1;

$query = $sql->run('SELECT * FROM booking WHERE statut IN(1,2,4) ORDER BY sourceID ASC, start ASC');

while ($r = $query->fetch()) {
  $year = date("Y", $r['start']);

  if ($year == $currentYear) {

    $loyerGlobal += trim($r['acompte'] + $r['solde']);
    $start = date("d/m/Y", $r['start']);
    $end = date("d/m/Y", $r['end']);

    $phone = chunk_split($r['phone'], 2, ' ');

    if ($prop == '') {
      $prop = $r['property'];
    }

    if ($sumLoyers == 0) {
      $sumLoyers += trim($r['acompte'] + $r['solde']);
    }

    if ($rent == $r['rent']) {
      $sumLoyers += trim($r['acompte'] + $r['solde']);
    }

    $pdf .= '<h1 class="roboto fs2 txtcenter mb3">Revenus locatifs <span class="cyan2">' . $currentYear . '</span></h1>';

    if ($rent != $r['rent']) {
      if ($rent != '') {
        $pdf .= '<tr class="white bggrey3"><td colspan="4"></td>';
        $pdf .= '<td class="white txtright pr2 bggrey2">Total <span class="gold pl1">' . $rent . '</span></td>';
        $pdf .= '<td class="arial txtright pr1 bgg2"><b>' . number_format($sumLoyers, 2, ',', ' ') . ' €</b></td></tr>';
        if ($prop == $r['property']) {
          $pdf .= '</tbody></table>';
        } else {
          $totLoyers[] = $sumLoyers;
          foreach ($totLoyers as $val) {
            $loyerTotal += $val;
          }
          $pdf .= '<tr class="bggrey3">';
          $pdf .= '<td colspan="4"></td>';
          $pdf .= '<td class="white txtright pr2 bggrey2">Total <span class="gold pl1">' . $prop . '</span></td>';
          $pdf .= '<td class="arial white txtright pr1 bgc2"><b>' . number_format($loyerTotal, 2, ',', ' ') . ' €</b></td>';
          $pdf .= '</tr>';
          $pdf .= '</tbody>';
          $pdf .= '</table>';
          $sumLoyers = $r['acompte'] + $r['solde'];
        }
        $totLoyers[] = $sumLoyers;
        $sumLoyers = $r['acompte'] + $r['solde'];
        $i = 1;
      }
      $rent = $r['rent'];

      $pdf .= '<table class="listCompta w100 arial">
      <thead>
      <tr>
      <th colspan="2" class="pl2 just bggrey1 white"><div class="w340p h100 pl2 pr2">' . $r['property'] . ' / ' . $r['rent'] . '</div></th>
      <th colspan="4"></th>
      </tr>
      <tr class="bglb white">
      <th width="200px">Locataire</th>
      <th width="200px">Arrivée</th>
      <th width="200px">Départ</th>
      <th width="200px">Acompte réglé</th>
      <th width="200px">Solde réglé</th>
      <th width="200px">Total réglé</th>
      </tr>
      </thead>';
    }

    if ($i % 2 == 1) {
      $css = 'bgfff';
    } else {
      $css = 'bgf2';
    }

    $pdf .= '<tbody>
    <tr class="' . $css . '">
    <td>
    <div>
    <div class="bold">' . $r['firstname'] . ' ' . $r['lastname'] . '</div>
    <div>' . $phone . '</div>
    <div>' . $r['email'] . '</div>
    </div>
    </td>
    <td class="arial txtcenter">' . $start . '</td>
    <td class="arial txtcenter">' . $end . '</td>
    <td>

    <div class="bold">' . number_format($r['acompte'], 2, ',', ' ') . '</div>';

    if ($r['comment_acompte'] != '' && $r['comment_acompte'] != '0') {
      $pdf .= '<div class="just mt1"><br />' . $r['comment_acompte'] . '</div>';
    }

    $pdf .= '
    </td>
    <td>
    <div class="bold">' . number_format($r['solde'], 2, ',', ' ') . '</div>';
    if ($r['comment_solde'] != '' && $r['comment_solde'] != '0') {
      $pdf .= '<div class="just mt1"><br />' . $r['comment_solde'] . '</div>';
    }

    $totalRent = $r['acompte'] + $r['solde'];

    $pdf .= '</td>
    <td class="arial txtright pr1">
    <div><b>' . number_format($totalRent, 2, ',', ' ') . '</b></div>';

    if ($r['comment_loyer'] != '' && $r['comment_loyer'] != '0') {
      $pdf .= '<div class="just mt1"><br />' . $r['comment_loyer'] . '</div>';
    }


    $pdf .= '</td>
    </tr>';
    $i++;
  }
}


$loyerTotal = 0;
foreach ($totLoyers as $val) {
  $loyerTotal += $val;
}

$pdf .= '<tr class="white bggrey3">
    <td colspan="4"></td>
    <td class="white txtright pr2 bggrey2">Total <span class="gold pl1">' . $rent . '</span></td>
    <td class="arial txtright pr1 bgc2 white"><b>' . number_format($sumLoyers, 2, ',', ' ') . ' €</b></td>
    </tr>
    <tr class=""><td colspan="6"></td></tr>
    <tr class="bggrey3">
    <td colspan="4"></td>
    <td class="white txtright pr2 bggrey2">Total <span class="gold pl1">Locations</span></td>
    <td class="arial white txtright pr1 bgrust"><b>' . number_format($loyerGlobal, 2, ',', ' ') . ' €</b></td>
    </tr>
    </tbody>
    </table>
    </div>
    </div>';

require_once __DIR__ . '/vendor/autoload.php';
ob_end_clean();
$mpdf = new \Mpdf\Mpdf(['debug' => true, 'mode' => 'utf-8', 'format' => 'A4-L']);
$stylesheet = file_get_contents('../css/pdf.css');
$mpdf->setFooter('{PAGENO}');
$mpdf->WriteHTML($stylesheet, 1);
$mpdf->WriteHTML($pdf, 2);
$mpdf->Output('Revenus locatifs ' . convertIso($prop) . ' - ' . $currentYear . '.pdf', \Mpdf\Output\Destination::INLINE);
exit;
