<?php
session_start();
include('../../data/data.php');

foreach ($_POST as $v => $value) {
    $$v = $value;
}

if (!isset($sourceID)) {
    if (isset($_SESSION['sourceID'])) {
        $sourceID = $_SESSION['sourceID'];
    } else {
        $sourceID = 1;
    }
}

$_SESSION['sourceID'] = $sourceID;

$storeYear = date("Y");

if (isset($_SESSION['storedYear'])) {
    $storeYear = $_SESSION['storedYear'];
}


$datetime = new DateTime('tomorrow');
$today = $datetime->format('d/m/Y');

$req = 'SELECT * FROM tarifs WHERE tarifID="' . $sourceID . '" AND periodID=0 ORDER BY start DESC';
$query = $sql->run($req);

if ($query->rowCount() != 0) {
    $r = $query->fetch();
?>
    <div id="tarifsList" class="cadre rel">
        <div class="cadre rel pt3 pb3 bggrey1">
            <div class="center pt1 pb3 bggrey2">
                <h2 class="txtcenter lightgrey">Tarifs du <span class="fs2 orange"><?php echo $today; ?></span> au <span class="fs2 deepgold"><?php echo date("d/m/Y", $r['end']); ?></span></h2>
                <table id="tab_tarifs" class="tablesTarifs">
                    <thead class="white">
                        <tr>
                            <th rowspan="2" class="w150p">Saison</th>
                            <th rowspan="2" class="bggrey1">Période de location</th>
                            <th colspan="2">Tarifs</th>
                            <th colspan="6">Tarifs majorés</th>
                            <th rowspan="2" class="bgc2">Tarif public</th>
                        </tr>
                        <tr>
                            <th class="tj bgc2">Semaine</th>
                            <th class="tj bgorange">Jour</th>
                            <th class="w150p bggrey1">Abritel Rdc/Etage</th>
                            <th class="w200p bggrey1">Abritel Chalet entier</th>
                            <th class="tj bggrey1">Airbnb</th>
                            <th class="tj bggrey1">Booking</th>
                            <th class="tj bggrey1">Holiday L</th>
                            <th class="tj bggrey1">PAP</th>
                        </tr>
                    </thead>
                    <tbody class="arial deepgrey bgwhite">
                        <?php

                        $major = array('T1', 'T2', 'T3', 'T4', 'T5', 'T6');

                        $query = $sql->run($req);

                        while ($r = $query->fetch()) {

                            $start = date("d/m/Y", $r['start']);  // Les mois en js sont numérotés à partir de zéro. Il faut donc retirer un mois à la date php, d'où le n-1.
                            $end = date("d/m/Y", $r['end']);

                            $tar1 = '';
                            $tar2 = '';
                            $tar3 = '';
                            $tar4 = '';
                            $tar5 = '';
                            $tar6 = '';
                            $tarifsMaj = array();
                            $i = 2;

                            foreach ($locationID[$sourceID] as $key => $val) {
                                $$key = $val;
                                if (in_array($key, $major)) {
                                    if ($$key != '') {
                                        if ($r['strict'] == 1) {
                                            if ($i > $r['minstay']) {
                                                $$key = round($r['day'] * (1 + ($$key / 100)));
                                                $tarifsMaj[] = $$key;
                                            } else {
                                                $tarifsMaj[] = '';
                                            }
                                        } else {
                                            $$key = round($r['day'] * (1 + ($$key / 100)));
                                            $tarifsMaj[] = $$key;
                                        }
                                    } else {
                                        $tarifsMaj[] = '';
                                    }
                                    $i++;
                                }
                            }

                            if ($r['minstay'] <= 1) {
                                $minstay = '1 nuit minimum';
                                if ($tarifsMaj[0] != '') {
                                    $prixSejour = 'Séjour à partir de ' . $tarifsMaj[0] . ' €';
                                } else {
                                    $prixSejour = 'Séjour à partir de ' . $r['day'] . ' €';
                                }
                            } else {
                                $minstay = $r['minstay'] . ' nuits minimum';
                                $min = $r['minstay'] - 1;

                                if ($r['minstay'] > 1 && $r['minstay'] < 7) {
                                    if ($tarifsMaj[$min] != '') {
                                        $prixSejour = 'Séjour à partir de ' . $tarifsMaj[$min] * $r['minstay'] . ' €';
                                    } else {
                                        $prixSejour = 'Séjour à partir de ' . $r['day'] * $min . ' €';
                                    }
                                } else {
                                    $prixSejour = 'Séjour à partir de ' . $r['week'] . ' €';
                                }
                            }

                            echo '<tr>';

                            switch ($r['season']) {
                                case 'B':
                                    echo '<td class="color1 white">B</td>';
                                    break;
                                case 'M':
                                    echo '<td class="color2 white">M</td>';
                                    break;
                                case 'H':
                                    echo '<td class="color3 white">H</td>';
                                    break;
                                case 'T':
                                    echo '<td class="color4 white">TH</td>';
                                    break;
                            }

                            echo '<td><b>' . $start . ' - ' . $end . '</b><p class="mt0 mediumgrey1"><i>' . $minstay . '</i></p></td>';
                            echo '<td class="cyan2"><b>' . $r['week'] . '</b> €</td>';
                            echo '<td class="cyan2">' . $r['day'] . ' €</td>';

                            $listCom = array(2, 3, 5, 7, 8, 10);

                            foreach ($comID as $val) {
                                if (in_array($val['id'], $listCom)) {
                                    if ($val['com'] != 0) {
                                        $nom = $val['nom'];
                                        $com = round($r['day'] / $val['com']);
                                        echo '<td class="cyan2 ">' . $com . ' €</td>';
                                    } else {
                                        echo '<td class="cyan2 ">NC</td>';
                                    }
                                }
                            }
                            echo '<td class="arial"><i>' . $prixSejour . '</i></td>';
                            echo '</tr>';
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

<?php } ?>