<?php
session_start();
include('../../data/data.php');

foreach ($_POST as $v => $value) {
  $$v = $value;
}

if (!isset($sourceID)) {
  if (isset($_SESSION['sourceID'])) {
    $sourceID = $_SESSION['sourceID'];
  } else {
    $sourceID = 1;
  }
}

$_SESSION['sourceID'] = $sourceID;

foreach ($rentals as $val) {
  if ($val['RID'] == $sourceID) {
    $propName = $val['prop'];
    $rentName = $val['rent'];
    $master = $val['master'];
    $property = $val['PID'];
    break;
  }
}

$slaves = '';
$nb = 0;

if ($master == 1) {
  foreach ($inter as $val) {
    if ($val['propID'] == $property && $val['rentID'] != $sourceID) {
      $slaves .= '\'' . $val['rentID'] . '\',';
      $nb++;   // Comptage du nombre de biens esclaves;
    }
  }
  $slaves = substr($slaves, 0, -1);
}

if (!isset($_POST['year'])) {
  if (!isset($_SESSION['year'])) {
    $year = date("Y");
  } else {
    $year = $_SESSION['year'];
  }
} else {
  $_SESSION['year'] = $_POST['year'];
}

$storeYear = $year;

$rent = '';
$color = '';
$listTarif = '';



$we = 1;
$query = $sql->run('SELECT com FROM supports WHERE id = 6')->fetchColumn();

if ($query) {
  $we = $query;
}

$query = $sql->run('SELECT property,rent FROM properties WHERE rentID="' . $sourceID . '"');
$r = $query->fetch();
$rent = $r['rent'];
$valprop = $r['property'];

$query = $sql->run('SELECT * FROM tarifs WHERE tarifID="' . $sourceID . '" AND periodID=0 ORDER BY start ASC');

while ($r = $query->fetch()) {

  $start = date("Y, n-1, j", $r['start']);  // Les mois en js sont numérotés à partir de zéro. Il faut donc retirer un mois à la date php, d'où le n-1.
  $end = date("Y, n-1, j", $r['end']);

  $listTarif .= "{id: '" . $r['id'] . "', startDate: new Date(" . $start . ") , endDate: new Date(" . $end . "), day: '" . $r['day'] . "', week: '" . $r['week'] . "', color: '" . $r['season'] . "' },";
}

$listTarif = substr($listTarif, 0, -1);
$listTarif = str_replace(array('B', 'M', 'H', 'T'), array('#8b9a45', '#1994be', '#F7A820', '#d37c02'), $listTarif);

?>

<div id="mainBook" class="page pt1 bgor2">
  <div class="cadre rel">
    <div class="cadre rel bggrey1 pb3">
      <div class="rel topTitle mt1 txtcenter bggrey1">
        <h1 id="titleBook" class="grilleTitle  bgfff"><span><?php echo $valprop; ?></span><?php echo $rent; ?></h1>
        <p id="openPreset" class="abs link white">Paramètres</p>
        <p id="openSupport" class="abs link white">Channels</p>
      </div>

      <div id="tarifsPreset" class="none rel">
        <?php
        $query = $sql->run('SELECT * FROM properties WHERE rentID="' . $sourceID . '"');
        $r = $query->fetch();

        if ($r['week_end'] != 0) {
          $we = $r['week_end'];
        } else {
          $we = 1;
        }

        if ($r['startAuth'] == 0) {
          $startAuth = date("d/m/Y", strtotime('today'));
          $today = strtotime('12:00:00');
          $deadline = strtotime('+1 years', $today);
          $endAuth = date("d/m/Y", $deadline);
        } else {
          $startAuth = date("d/m/Y", $r['startAuth']);
          $endAuth = date("d/m/Y", $r['endAuth']);
        }

        $periodLoc = 'Du <span class="gold">' . $startAuth . '</span> au <span class="gold">' . $endAuth . '</span>';

        if ($r['cleaning'] == 0) {
          $cleaning = "Non précisé";
        } else {
          $cleaning = $r['cleaning'] . ' €';
        }

        if ($r['taxe_sejour'] == 0) {
          $tj = "Non précisé";
        } else {
          $tj = $r['taxe_sejour'] . ' €';
        }

        $startWeek = '';
        $startDay = '';

        switch ($r['startWeek']) {
          case '1':
            $startWeek = 'Lundi';
            break;
          case '2':
            $startWeek = 'Mardi';
            break;
          case '3':
            $startWeek = 'Mercredi';
            break;
          case '4':
            $startWeek = 'Jeudi';
            break;
          case '5':
            $startWeek = 'Vendredi';
            break;
          case '6':
            $startWeek = 'Samedi';
            break;
          case '7':
            $startWeek = 'Dimanche';
            break;
          case '0':
            $startWeek = 'Libre';
            break;
        }

        switch ($r['startDay']) {
          case '1':
            $startDay = 'Lundi';
            break;
          case '2':
            $startDay = 'Mardi';
            break;
          case '3':
            $startDay = 'Mercredi';
            break;
          case '4':
            $startDay = 'Jeudi';
            break;
          case '5':
            $startDay = 'Vendredi';
            break;
          case '6':
            $startDay = 'Samedi';
            break;
          case '7':
            $startDay = 'Dimanche';
            break;
          case '0':
            $startDay = 'Libre';
            break;
        }

        $_SESSION['presets'] = [$startAuth, $endAuth, $r['cleaning'], $r['taxe_sejour'], $r['startWeek'], $r['startDay'], $r['startTime'], $r['endTime'], $r['T1'], $r['T2'], $r['T3'], $r['T4'], $r['T5'], $r['T6'], $r['week_end']];
        $presets = $_SESSION['presets'];
        ?>

        <h2 class="mt0 txtcenter white">Paramètres des tarifs</h2>
        <p id="closePreset" class="abs under gold pointer">Fermer</p>
        <div class="bggrey3">
          <div id="preset" class="rel pa3 bggrey2 white rad3">
            <p id="modPreset" class="abs pointer"></p>
            <div id="padlock" class="clear paramT oneline">
              <div>Mise en location</div>
              <div><?php echo $periodLoc; ?></div>
            </div>
            <div id="percent" class="clear paramT oneline">
              <div>Tarifs majorés</div>
              <div>
                <ul class="pa0 listinline">
                  <li>de 1 à 6 nuits : </li>
                  <li><span class="gold">+<?php echo $r['T1']; ?> %</span></li>
                  <li><span class="gold">+<?php echo $r['T2']; ?> %</span></li>
                  <li><span class="gold">+<?php echo $r['T3']; ?> %</span></li>
                  <li><span class="gold">+<?php echo $r['T4']; ?> %</span></li>
                  <li><span class="gold">+<?php echo $r['T5']; ?> %</span></li>
                  <li><span class="gold">+<?php echo $r['T6']; ?> %</span></li>
                </ul>
              </div>
            </div>
            <div id="majweek" class="flex paramT oneline">
              <div>Maj week-end</div>
              <div><?php echo $r['week_end']; ?></div>
            </div>
            <div id="cleaning" class="clear paramT oneline">
              <div>Frais de ménage</div>
              <div><?php echo $cleaning; ?></div>
            </div>
            <div id="taxes" class=" clear paramT oneline">
              <div>Taxe de séjour</div>
              <div><?php echo $tj; ?></div>
            </div>
            <div id="startDay" class=" clear paramT twolines">
              <div>Jour d'arrivée</div>
              <div>
                <table>
                  <tr>
                    <td>Séjour d'une semaine:</td>
                    <td class="pl2 pr3 gold"><?php echo $startWeek; ?></td>
                  </tr>
                  <tr>
                    <td>Autres séjours:</td>
                    <td class="pl2 gold"><?php echo $startDay; ?></td>
                  </tr>
                </table>
              </div>
            </div>
            <div id="startTime" class=" clear paramT twolines">
              <div>Horaires</div>
              <div>
                <table>
                  <tr>
                    <td>Heure d'arrivée:</td>
                    <td class="pl2 pr3 gold"><?php echo $r['startTime']; ?></td>
                  </tr>
                  <tr>
                    <td>Heure de départ:</td>
                    <td class="pl2 gold"><?php echo $r['endTime']; ?></td>
                  </tr>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div id="supports" class="none rel">
        <h2 class="mt0 txtcenter white">Canaux de diffusion</h2>
        <p id="closeSupport" class="abs under gold pointer">Fermer</p>
        <div class="bggrey3">
          <div id="support" class="rel pa3 bggrey2 white rad3">
            <h3 class="txtcenter">Canaux de diffusion et commissions</h3>
            <form id="formSupport" method="post">
              <table id="tabModsup" class="tablesup center">
                <thead class="gold bggrey1">
                  <tr>
                    <th></th>
                    <th colspan="4" class="txtcenter">Commissions</th>
                  </tr>
                  <tr>
                    <th>Nom</th>
                    <th class="w100p">Quotient</th>
                    <th class="txtcenter">Location</th>
                    <th></th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $query = $sql->run('SELECT * FROM supports WHERE nom!="SCH" ORDER BY nom ASC');
                  while ($r = $query->fetch()) {

                    $com = '';
                    $loc = '';

                    if ($r['com'] > 0) {
                      $com = str_replace('.', ',', $r['com']);
                    }

                    if ($r['supID'] == 0) {
                      if ($r['com'] > 0) {
                        $loc = 'Toutes';
                      }
                    } else {
                      $loc = $r['rent'];
                    }
                  ?>
                    <tr>
                      <td><?php echo $r['nom']; ?></td>
                      <td class="txtright pr2"><?php echo $com; ?></td>
                      <td class="rel mauve"><?php echo $loc; ?></td>
                      <td class="rel">
                        <div class="abs modSupport pointer" data_ID="<?php echo $r['ID']; ?>" data_nom="<?php echo $r['nom']; ?>" data_com="<?php echo $com; ?>"></div>
                      </td>
                      <td class="rel">
                        <div class="abs garbage pointer" data_ID="<?php echo $r['ID']; ?>" data_type="delete"></div>
                      </td>
                    </tr>
                  <?php } ?>
                </tbody>
              </table>
            </form>
            <div class="mt2">
              <h3 class="txtcenter">Ajouter un canal de diffusion</h3>
              <form id="newSupport">
                <table id="tabNewSup" class="tablesup center">
                  <thead class="gold bggrey1">
                    <tr>
                      <th></th>
                      <th colspan="4" class="txtcenter">Commissions</th>
                    </tr>
                    <tr>
                      <th>Nom</th>
                      <th>Quotient</th>
                      <th colspan="3">Location</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td><input id="newName" type="text" name="nom" value="" class="pl1" /></td>
                      <td><input type="text" id="newChannel" name="com" value="" class="w100p pl1" /></td>
                      <td>
                        <select name="rent" class="w200p">
                          <option value="T" selected>Toutes</option>
                          <?php
                          foreach ($rentID as $val) {
                            $target = explode('|', $val);
                            echo '  <option value="' . $val . '">' . $target[0] . '</option>';
                          } ?>
                        </select>

                      </td>
                      <td colspan="2">
                        <div id="newSup" class="valSupport button">Valider</div>
                      </td>
                    </tr>
                  </tbody>
                </table>
                <input type="hidden" name="type" value="new" />
              </form>
            </div>
            <div class="mt2">
              <h3 class="txtcenter">Ajouter une commission</h3>
              <form id="newCommission">
                <table id="tabNewSup" class="tablesup center">
                  <thead class="gold bggrey1">
                    <tr>
                      <th></th>
                      <th colspan="4" class="txtcenter">Commissions</th>
                    </tr>
                    <tr>
                      <th>Canal</th>
                      <th>Quotient</th>
                      <th colspan="3">Location</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td>
                        <select name="canal" class="w200p">
                          <?php
                          $query = $sql->run('SELECT * FROM supports WHERE nom!="SCH" ORDER BY nom ASC');
                          while ($r = $query->fetch()) {
                            echo '  <option value="' . $r['nom'] . '">' . $r['nom'] . '</option>';
                          }
                          ?>
                        </select>
                      <td><input type="text" id="newQuot" name="com" value="" class="w100p pl1" /></td>
                      <td>
                        <select name="rent" class="w200p">
                          <option value="T" selected>Toutes</option>
                          <?php
                          foreach ($rentID as $val) {
                            $target = explode('|', $val);
                            echo '  <option value="' . $val . '">' . $target[0] . '</option>';
                          } ?>
                        </select>

                      </td>
                      <td colspan="2">
                        <div id="newCom" class="valSupport button">Valider</div>
                      </td>
                    </tr>
                  </tbody>
                </table>
                <input type="hidden" name="type" value="newCom" />
              </form>
            </div>

            <script type="text/javascript">
              $('#openSupport').click(function() {
                if ($('#supports').is(':hidden')) {
                  $('#supports').slideDown('slow');
                } else {
                  $('#supports').slideUp();
                }
              });

              $('.garbage').click(function() {
                var type = $(this).attr('data_type');
                var targetID = $(this).attr('data_ID');

                if (confirm("Confirmez-vous la suppression de ce canal ?")) {
                  $.post("tarifs/valsup.php", {
                    type: type,
                    ID: targetID
                  }, function(response) {
                    $('#visu').html(response);
                  });

                  $(this).closest('tr').remove();

                  return false;
                }
              });


              $('#newSup').click(function() {

                var newName = $('#newName').val().toLowerCase();
                var supports = <?php echo $channels; ?>;
                var quotient = $('#newChannel').val().replace(",", ".");

                if (newName.trim() === '') {
                  alert('Il faut attribuer un nom au canal');
                  return;
                }

                if (jQuery.inArray(newName, supports) !== -1) {
                  alert('Un canal porte déjà ce nom !');
                  return;
                }

                if (quotient.trim() === '') {
                  alert('Indiquez un quotient');
                  return;
                }

                var quotient = parseFloat(quotient);

                if (quotient > 1) {
                  alert('Le Quotient doit être inférieur à 1');
                  return;
                }

                $.post("tarifs/valsup.php", $("#newSupport").serialize(), function(response) {
                  $('#support').html(response);
                });
                return false;
              });

              $('#newCom').click(function() {

                var quotient = $('#newQuot').val().replace(",", ".");

                if (quotient.trim() === '') {
                  alert('Indiquez un quotient');
                  return;
                }

                var quotient = parseFloat(quotient);

                if (quotient > 1) {
                  alert('Le Quotient doit être inférieur à 1');
                  return;
                }

                $.post("tarifs/valsup.php", $('#newCommission').serialize(), function(response) {
                  $('#support').html(response);
                });
                return false;
              });

              $('.modSupport').click(function() {
                var nom = $(this).attr('data_nom');
                var targetID = $(this).attr('data_ID');
                var com = $(this).attr('data_com');

                $('.trSup').remove();

                $(this).closest('tr').after("<tr class='trSup bgwhite'><td><input id='inputName' type='text' value='" + nom + "' class='center pl1' /></td><td><input id='inputCom' type='text' value='" + com + "' class='shortInput center pl1' /></td><td colspan='3' class='txtcenter'><div class='clear'><div class='w50 left txtleft'><img src='<?php echo $domain; ?>/images/icones/valider.svg' class='valSupport ico32 pointer' data_id='" + targetID + "' data_com='" + com + "'></div><div class='w50 left txtright'><img src='<?php echo $domain; ?>/images/icones/annuler.svg' class='cancelSupport ico32 pointer'></div></div></td></tr>");

                $('.valSupport').click(function() {
                  var targetID = $(this).attr('data_ID');
                  var rent = $('#inputName').val();
                  var quotient = $('#inputCom').val().replace(",", ".");

                  if (quotient.trim() === '') {
                    var quotient = 0;
                  }

                  var quotient = parseFloat(quotient);

                  if (quotient > 1) {
                    alert('Le Quotient doit être inférieur à 1');
                    return;
                  }

                  $.post("tarifs/valsup.php", {
                    type: 'mod',
                    id: targetID,
                    rent: rent,
                    com: quotient
                  }, function(response) {
                    $('#support').html(response);
                  });
                  return false;
                });

                $('.cancelSupport').click(function() {
                  $('.trSup').remove();
                });
              });

              $('#closeSupport').click(function() {
                $('#supports').slideUp();
              });
            </script>

          </div>
        </div>
      </div>

      <h2 class="mt1 txtcenter lightgrey">Grille des tarifs</h2>
      <div id="grilleTarif" class="none grille"></div>
    </div>
  </div>

  <?php
  $datetime = new DateTime('tomorrow');
  $today = $datetime->format('d/m/Y');

  if ($master != 1) {
    $req = 'SELECT * FROM tarifs WHERE tarifID="' . $sourceID . '" AND periodID=0 ORDER BY start ASC';
  } else {
    $req = "SELECT 
    SUM(day) AS sum_day, 
    SUM(week) AS sum_week, 
    start,end,minstay,strict,season 
    FROM tarifs 
    WHERE tarifID IN('1','2') AND periodID = 0 
    GROUP BY start 
    ORDER BY start ASC";
  }
  $query = $sql->run($req);

  if ($query->rowCount() != 0) {
    $r = $query->fetch();
  ?>
    <div id="tarifsList" class="cadre rel">
      <div class="cadre rel pt3 pb3 bggrey1">
        <div class="center pt1 pb3 bggrey2">
          <div class="w90 clear center">
            <h2 class="txtcenter lightgrey">Tarifs <span id="yearRate" class="arial gold"></span><a id="printTarifs" href="" target="_blank" class="right link pa1 ml3 rad3 fs18 white"><img src="../images/icones/pdf.svg" class="pdf" /><?php echo $rent; ?></a></h2>
          </div>
          <table id="tab_tarifs" class="w90 tablesTarifs">
            <thead class="white">
              <tr>
                <th rowspan="2" class="w150p">Saison</th>
                <th rowspan="2" class="bggrey1">Période de location</th>
                <th colspan="3">Tarifs</th>
                <th colspan="6" class="bggrey1">Tarifs majorés</th>
              </tr>
              <tr>
                <th class="tj bgc2">Semaine</th>
                <th class="tj bgorange">Jour</th>
                <th class="tj color4">Week-end</th>
                <th class="tj bgv2">Airbnb</th>
                <th class="tj bgv2">Airbnb WE</th>
                <th class="tj bgv2">Abritel</th>
                <th class="tj bgv2">Abritel WE</th>
                <th class="tj bgv2">Booking</th>
                <th class="tj bgv2">Booking WE</th>
              </tr>
            </thead>
            <tbody class="arial deepgrey bgwhite">
              <?php

              $major = array('T1', 'T2', 'T3', 'T4', 'T5', 'T6');

              $query = $sql->run($req);

              while ($r = $query->fetch()) {

                $start = date("d/m/Y", $r['start']);  // Les mois en js sont numérotés à partir de zéro. Il faut donc retirer un mois à la date php, d'où le n-1.
                $end = date("d/m/Y", $r['end']);
                $yearTarif = date("Y", $r['start']);

                $tar1 = '';
                $tar2 = '';
                $tar3 = '';
                $tar4 = '';
                $tar5 = '';
                $tar6 = '';
                $tarifsMaj = array();
                $i = 2;

                if (isset($r['day'])) {
                  $day = $r['day'];
                  $week = $r['week'];
                } else {
                  $day = round($r['sum_day'] + ($r['sum_day'] * (5 / 100)));
                  $week = round($r['sum_week'] + ($r['sum_week'] * (5 / 100)));
                }

                foreach ($locationID[$sourceID] as $key => $val) {
                  $$key = $val;
                  if (in_array($key, $major)) {
                    if ($$key != '') {
                      if ($r['strict'] == 1) {
                        if ($i > $r['minstay']) {
                          $$key = round($day * (1 + ($$key / 100)));
                          $tarifsMaj[] = $$key;
                        } else {
                          $tarifsMaj[] = '';
                        }
                      } else {
                        $$key = round($day * (1 + ($$key / 100)));
                        $tarifsMaj[] = $$key;
                      }
                    } else {
                      $tarifsMaj[] = '';
                    }
                    $i++;
                  }
                }

                if ($r['minstay'] <= 1) {
                  $minstay = '1 nuit minimum';
                } else {
                  $minstay = $r['minstay'] . ' nuits minimum';
                  $min = $r['minstay'] - 1;
                }

                echo '<tr class="rate ' . $yearTarif . '">';

                switch ($r['season']) {
                  case 'B':
                    echo '<td class="color1 white">B</td>';
                    break;
                  case 'M':
                    echo '<td class="color2 white">M</td>';
                    break;
                  case 'H':
                    echo '<td class="color3 white">H</td>';
                    break;
                  case 'T':
                    echo '<td class="color4 white">TH</td>';
                    break;
                }

                $weekend = round($day * $we);

                echo '<td><b>' . $start . ' - ' . $end . '</b><p class="mt0 mediumgrey1"><i>' . $minstay . '</i></p></td>';
                echo '<td class="cyan2"><b>' . $week . '</b> €</td>';
                echo '<td class="cyan2">' . $day . ' €</td>';
                echo '<td class="cyan2">' . $weekend . ' €</td>';

                $listCom = array(1, 2, 3, 4, 5, 6);

                foreach ($comID as $val) {
                  if (in_array($val['id'], $listCom)) {
                    if ($val['com'] != 0) {
                      $nom = $val['nom'];
                      $com = round($day * $val['com']);
                      echo '<td class="cyan2 ">' . $com . ' €</td>';
                    } else {
                      echo '<td class="cyan2 ">NC</td>';
                    }
                  }
                }
                echo '</tr>';
              }
              ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

  <?php } ?>

  <script type="text/javascript">
    var screenWidth = $(window).width();
    var minGrilleHeight = 463;
    if (screenWidth < 1315 && screenWidth > 890) {
      var minGrilleHeight = 663;
    }
    if (screenWidth < 890) {
      var minGrilleHeight = 863;
    }
    $('.grille').css('min-height', minGrilleHeight);
    $('.grille').fadeIn(2000);

    $(document).ready(function() {

      function deleteEvent(event) {
        var dataSource = $('#grilleTarif').data('calendar').getDataSource();

        for (var i in dataSource) {
          if (dataSource[i].id == event.id) {
            dataSource.splice(i, 1);
            id = event.id;

            $.post("delevent.php", {
              id: id,
              form: 'tarif'
            }, function(data) {
              $('#visu').html(data);
            });
            break;
          }
        }
        $('#grilleTarif').data('calendar').setDataSource(dataSource);
      }

      $(function() {
        var currentYear = new Date().getFullYear();

        $('#grilleTarif').calendar({
          style: 'background',
          startYear: <?php echo $storeYear; ?>,
          enableRangeSelection: true,
          enableContextMenu: true,
          contextMenuItems: [{
            text: 'Supprimer',
            click: deleteEvent
          }],

          customDayRenderer: function(element, date) {

            currentDay = moment().subtract(1, 'days').unix();
            dayDate = moment(date).utcOffset(0, true).unix();

            if (dayDate < currentDay) {
              $(element).parent().addClass('disabled');
            } else {
              for (var i = 0; i < this.dataSource.length; i++) {

                startSource = moment(this.dataSource[i].startDate).unix();
                endSource = moment(this.dataSource[i].endDate).add(1, 'days').unix();

                var colors = ['#4b5e6c', '#73828c', '#1994be', '#F7A820', '#d37c02'];

                if (dayDate >= startSource && dayDate <= endSource) {
                  $(element).css('background-color', this.dataSource[i].color);

                  if (jQuery.inArray(this.dataSource[i].color, colors) !== -1) {
                    $(element).addClass('white');
                  }
                }
              }
            }
          },

          selectRange: function(e) {

            start = moment(e.startDate).format("DD-MM-Y");
            end = moment(e.endDate).format("DD-MM-Y");

            if (e.events[0] == null) {
              id = 0;
              color = '';
            } else {
              id = e.events[0].id;
              color = e.events[0].color;
            }

            $.ajax({
              data: {
                start: start,
                end: end,
                id: id,
                sourceID: <?php echo $sourceID; ?>,
                prop: '<?php echo $valprop; ?>',
                rent: '<?php echo $rent; ?>',
                color: color
              },
              type: 'POST',
              url: 'tarifs/formtarifs.php',
              success: function(data) {
                $('#visu').html(data);
              }
            });
          },

          mouseOnDay: function(e) {
            if (e.events.length > 0) {

              var content = '';

              for (var i in e.events) {
                content += '<div class="event-tooltip-content">' +
                  '<div class="event-jour" style="color:' + e.events[i].color + '">Jour: ' + e.events[i].day + '</div>' +
                  '<div class="event-semaine">Semaine: ' + e.events[i].week + '</div>' +
                  '</div>';
              }

              $(e.element).popover({
                trigger: 'manual',
                container: 'body',
                html: true,
                content: content
              });

              $(e.element).popover('show');
            }
          },

          mouseOutDay: function(e) {
            // if (e.events.length > 0) {
            $(e.element).popover('hide');
            //  }
          },

          dayContextMenu: function(e) {
            $(e.element).popover('hide');
          },

          renderEnd: function(e) {
            year = $('.calendar-header table>[class=year-title]').text(); // Détecter l'élément (enfant) ayant uniquement la classe year-title
            source = <?php echo $sourceID; ?>;
            $('.rate').addClass('none');
            $('.' + year).removeClass('none');
            $('#yearRate').text(year);
            $('#printTarifs').attr('href', '../print-tarif.php?ID=' + source + '&chrono=' + year);
            localStorage.setItem("year", year);
          },

          dataSource: [<?php echo $listTarif; ?>]

        });
      });

      $('#picker p').click(function() {
        scrollToAnchor('pick');
      });

      /*   $('#picker input.inputDate').change(function () {
      alert('change');
    });*/
    });

    $('#openPreset').click(function() {
      if ($('#tarifsPreset').is(':hidden')) {
        $('#tarifsPreset').slideDown('slow');
      } else {
        $('#tarifsPreset').slideUp();
      }
    });

    $('#modPreset').click(function() {
      $.post("tarifs/tarifspreset.php", {
          id: '<?php echo $sourceID; ?>',
          startAuth: '<?php echo $presets[0]; ?>',
          endAuth: '<?php echo $presets[1]; ?>',
          clean: '<?php echo $presets[2]; ?>',
          taxe: '<?php echo $presets[3]; ?>',
          week: '<?php echo $presets[4]; ?>',
          day: '<?php echo $presets[5]; ?>',
          startTime: '<?php echo $presets[6]; ?>',
          endTime: '<?php echo $presets[7]; ?>',
          T1: '<?php echo $presets[8]; ?>',
          T2: '<?php echo $presets[9]; ?>',
          T3: '<?php echo $presets[10]; ?>',
          T4: '<?php echo $presets[11]; ?>',
          T5: '<?php echo $presets[12]; ?>',
          T6: '<?php echo $presets[13]; ?>',
          weekend: '<?php echo $presets[14]; ?>'
        },
        function(data) {
          $('#preset').html(data);
        });
    });

    $('#closePreset').click(function() {
      $('#tarifsPreset').slideUp();
      $.post("tarifs/annulpreset.php", {
        id: <?php echo $sourceID; ?>
      }, function(response) {
        $('#preset').html(response);
        $('#toAll').attr('id', 'modPreset');
      });
      return false;
    });
  </script>
</div>