<?php
session_start();
include('../data/data.php');

error_reporting(E_ALL);
ini_set('display_errors', 'On');

/* --------------  Connexion  -------------------- */

$user = '';
$pass = '';

if (!isset($_SESSION['admin'])) {
  if (isset($_COOKIE['login']) && isset($_COOKIE['pass'])) {
    $_SESSION['admin'] = 'admin';
  }
}
?>

<!DOCTYPE html>
<html lang="fr">

<head>
  <meta charset="UTF-8" />
  <?php //include('../data/entete.php');   
  ?>
  <title> <?php //echo $title;          
          ?> </title>
  <meta name="description" content="<?php //echo $content;         
                                    ?>" />
  <meta name="keywords" content="<?php //echo $key;          
                                  ?>" />
  <meta name="viewport" content="width=device-width">
  <!-- META FOR IOS & HANDHELD -->
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta name="HandheldFriendly" content="true" />
  <meta name="apple-touch-fullscreen" content="YES" />
  <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css?family=Frank+Ruhl+Libre|Noto+Sans" rel="stylesheet">
  <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/fullcalendar.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/scheduler.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/daterangepicker.css">
  <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/bootstrap.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/bootstrap-year-calendar.css" />
  <link href="//netdna.bootstrapcdn.com/bootstrap/3.0.0/css/bootstrap-glyphicons.css" rel="stylesheet">

  <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/pnotify.css" media="screen" />
  <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/clockpicker.css" media="screen" />
  <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/slick1.css" media="screen" />
  <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/style.css" media="screen" />
  <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/admin.css?ver=<?php echo time(); ?>" media="screen" />
</head>

<body>
  <?php
  if (isset($_SESSION['admin'])) {
  ?>
    <div id="page">
      <div id="adminhead" class="rel mb3 fs3 txtcenter bggrey1 white">
        <p id="headerTitle" class="mt0 fs3">Calendrier</p>
        <div id="logout" class="abs pointer bggrey3 tooltips" title="Déconnexion">
          <img src="../images/icones/logout.svg" />
        </div>
      </div>
      <div id="content">
        <?php
        if (isset($_GET['page'])) {
          $page = $_GET['page'];

          if (preg_match("/\bbilan-compable\b/i", $page)) {
            include('../print-bilan.php');
          }
        }
        ?>
      </div>

      <nav id="bt-menu" class="bt-menu">
        <ul id="mainmenu" class="listinline white">
          <li><span data_url="booking/booking.php" data_title="Calendrier" data_color="#324552" data_display="1" class="bt-icon icon-user-outline">CALENDRIER</span></li>
          <li><span data_url="booking/resa.php" data_title="Réservations" data_color="#cc7114" data_display="0" class="bt-icon icon-sun">R&Eacute;SA</span></li>
          <li><span data_url="tarifs/tarifs.php" data_title="Tarifs et disponibilités" data_color="#FFBC40" data_display="1" class="bt-icon icon-star">TARIFS</span></li>
          <!--      <li><span data_url="mailing/mailing.php" data_title="Emails & Contacts" data_color="#7bab5a" data_display="0" class="bt-icon icon-windows">CONTACT</span></li> -->
          <li><span data_url="properties/property.php" data_title="Biens à louer" data_color="#ED8E00" data_display="1" class="bt-icon icon-bubble">BIENS</span></li>
          <li><span data_url="compta/compta.php" data_title="Comptabilité" data_color="#324552" data_display="0" class="bt-icon icon-speaker">COMPTA</span></li>
        </ul>
        <div id="selectRent" class="none bggrey1">
          <ul>
            <?php
            foreach ($masters as $key => $m) {
            ?>
              <li class="rentli bgc1 white"><?php echo $m['name']; ?></li>
              <li>
                <ul id="rents" class="rentlist mt0 mb2">
                  <?php
                  if (!isset($sourceID)) {
                    if (isset($_SESSION['sourceID'])) {
                      $sourceID = $_SESSION['sourceID'];
                    } else {
                      $sourceID = 1;
                    }
                  }

                  $select = '';
                  $hideTarif = '';
                  $class = 'rentOn';

                  foreach ($rentals as $val) {
                    if ($val['PID'] == $m['propID']) {

                      if ($val['RID'] == $sourceID) {
                        $select = 'selected';
                      }

                      if (in_array($val['RID'], $autoTarifs)) {
                        $hideTarif = 'hideTarif';
                      }

                      $name = ucfirst(str_replace("Chalet de ", "", $m['name']));

                  ?>
                      <li class="rentli <?php echo $hideTarif; ?> white <?php echo $select; ?>">
                        <span class="rentOn" data_source="<?php echo $val['RID']; ?>" data_auth="<?php echo $val['auth']; ?>" data_prop="<?php echo $name; ?>" data_rent="<?php echo $val['rent']; ?>"><?php echo $val['rent']; ?></span>
                      </li>
                  <?php
                    }
                    $noTarif = '';
                    $select = '';
                  }
                  $noTarif = '';
                  $select = '';
                  ?>
                </ul>
              </li>
            <?php } ?>
          </ul>
          <div id="selectPage"></div>
        </div>
        <div id="selector" class="white">
          <p class="mt0 txtcenter"></p>
        </div>
      </nav>
    </div>
    <div id="visu"></div>
    <div id="calc"></div>

    <script type="text/javascript" src="<?php echo $domain; ?>js/jquery.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/slick.min.js"></script>

    <script type="text/javascript">
      $(document).ready(function() {

        window.history.pushState(null, "", window.location.href);
        window.onpopstate = function() {
          window.history.pushState(null, "", window.location.href);
        };

        $.ajax({
          url: 'booking/booking.php',
          dataType: 'html',
          success: function(response) {
            $('#content').html(response);
          }
        });

        function scrollToAnchor(aid) {
          var aTag = $("a[name='" + aid + "']");
          $('html,body').animate({
            scrollTop: aTag.offset().top
          }, 'slow');
        }

        $('#selector').click(function() {
          $("#selectRent").slideToggle("slow");
        });


        // MENU ------------------------------------------

        $('#mainmenu li span').click(function() {
          var urlPage = $(this).attr('data_url');
          var titlePage = $(this).attr('data_title');
          var colorPage = $(this).attr('data_color');
          var displayPage = $(this).attr('data_display');
          var properties = <?php echo $countRent; ?>;

          if (typeof localStorage.year === 'undefined') {
            localStorage.setItem("year", new Date().getFullYear());
          }

          var year = localStorage.getItem("year");

          $.ajax({
            url: urlPage,
            cache: false,
            method: "POST",
            data: {
              year: year
            },
            dataType: 'html',
            success: function(response) {
              $('#content').html(response);
            }
          });
          $('#headerTitle').text(titlePage);
          $('#adminhead').css('background-color', colorPage);

          switch (displayPage) {
            case '0':
              $("#selector").hide();
              break;
            case '1':
              if (properties > 1) {
                $("#selector").show();
              } else {
                $("#selector").hide();
              }
              break;
          }

          if (titlePage === 'Biens à louer') {
            $('.rentli span').each(function() {
              if ($(this).hasClass('rentOff')) {
                $(this).toggleClass('rentOff rentOn');
              }
            });
          } else {
            $('.rentli span').each(function() {
              if ($(this).attr('data_auth') == 0) {
                if ($(this).hasClass('rentOn')) {
                  $(this).toggleClass('rentOn rentOff');
                } else {
                  $(this).addClass('rentOff');

                }
              }
            });
          }
          /*    if (titlePage === 'Tarifs et disponibilités') {
        $('.hideTarif').hide();
      } else
      {
      $('.hideTarif').show();
    }*/
        });

        $('#mainmenu li').click(function() {
          $(this).addClass('cyan2');
          $(this).siblings().removeClass('cyan2');
        });

        $('.rentOn').click(function() {
          var source = $(this).attr("data_source");
          var property = $(this).attr("data_prop");
          var rent = $(this).attr("data_rent");
          var page = $('#headerTitle').text();
          $("#selectRent").slideUp('slow');

          switch (page) {
            case 'Calendrier':
              var year = localStorage.getItem("year");
              $.post("booking/bookselect.php", {
                sourceID: source,
                prop: property,
                rent: rent,
                year: year
              }, function(data) {
                $('#ajaxBook').html(data);
              });

              $(".grilleTitle").html('<span class="deepgrey">' + property + '</span>' + $(this).attr("data_rent"));
              $("#selector p").html(property + ' - <span class="orange">' + rent + ' </span> ');
              break;

            case 'Tarifs et disponibilités':

              var year = localStorage.getItem("year");
              $.post("tarifs/tarifselect.php", {
                sourceID: source,
                prop: property,
                year: year
              }, function(data) {
                $('#tarifs').html(data);
              });
              $("#titleTarifs").html('<span class="deepgrey">' + property + '</span>  -  ' + $(this).attr("class"));
              $("#selector p").html(property + ' - <span class="orange">' + rent + ' </span> ');
              break;

            case 'Biens à louer':

              $.post("properties/property.php", {
                sourceID: source,
                prop: property,
                rent: rent
              }, function(data) {
                $('#ajaxRent').html(data);
              });

              $(".grilleTitle").html('<span class="deepgrey">' + property + '</span>' + $(this).attr("data_rent"));
              $("#selector p").html(property + ' - <span class="orange">' + rent + ' </span> ');
              break;
          }
        });

        new $.Zebra_Tooltips($('.tooltips'));

        $('#logout').click(function() {
          $.get("logout.php", function(response) {
            $('#visu').html(response);
          });
          return false;
        });
      });
    </script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/fullcalendar/moment.min.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/fullcalendar/fullcalendar.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/fullcalendar/scheduler.min.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/fullcalendar/fr.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/bootcalendar/bootstrap.min.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/bootcalendar/bootstrap-year-calendar.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/bootcalendar/bootstrap-year-calendar.fr.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/jquery.daterangepicker.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/pnotify.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/clockpicker.min.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/autosize.min.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/tooltips.min.js"></script>
  <?php
  } else {
  ?>
    <script type="text/javascript" src="<?php echo $domain; ?>js/jquery.js"></script>
    <div id="adminhead" class="rel mb3 fs3 txtcenter watergreen white">
      <p id="headerTitle" class="mt0 fs3">SERRE CHEVALIER HOLIDAYS</p>
    </div>
    <div id="portail">
      <div id="bgLogin" class="pt2 polar">
        <form id="check" method="post" class="center txtcenter white">
          <p class="mb2"><input type="text" name='login' id="log" placeholder=" Identifiant" class="w250p pl1" /></p>
          <p class="pb2"><input type="password" name='pass' id="pass" placeholder=" Mot de passe" class="password w250p pl1" /><span id="showHide" class="voir"></span></p>
          <div class="inbl">
            <p id="subP" class="mt0 pl2 pr2 bggrey1 white pointer">Valider</p>
          </div>
          <p class="field mt2"><input type="checkbox" name='cook' class="mr2" /> Se souvenir de moi</p>
        </form>
      </div>
    </div>
    <div id="result"></div>
    <script type="text/javascript">
      $("#showHide").click(function() {
        $(this).toggleClass("voir masquer");
        if ($(this).hasClass("voir")) {
          $(".password").attr("type", "password");
        } else {
          $(".password").attr("type", "text");
        }
      });

      $('#subP').click(function() {
        var login = $.trim($('#log').val());
        var pass = $.trim($('#pass').val());
        if (login === '' || pass === '') {} else {
          $.post("control.php", $("#check").serialize(), function(response) {
            $('#result').html(response);
          });
          return false;
        }
      });
    </script>
  <?php } ?>
</body>

</html>