<?php
session_start();
include('data/data.php');

if (isset($_SESSION['lang'])) {
    $lang = $_SESSION['lang'];
} else {

    $listLang = array('en\/', 'it\/', 'sp\/', 'de\/', 'nl\/');
    foreach ($listLang as $findLang) {
        if (preg_match("/\b$findLang\b/i", $page)) {
            $lang = substr($findLang, 0, -2);
            break;
        }
    }
}

if (!isset($lang)) {
    $lang = 'fr';
}

$lang_content = file_get_contents('includes/langues.json');

$tr = json_decode($lang_content, true);

$rentPages = array('location', 'rent', 'affitto', 'alquiler', 'vermietung', 'plek');
$urlcontrol = false;

foreach ($rentPages as $rentPage) {
    if (preg_match("/\b$rentPage\b/i", $page)) {
        $urlcontrol = true;
        break;
    }
}

?>

<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="gb18030">

    <?php include('data/entete.php'); ?>
    <title><?php echo $title; ?></title>
    <meta name="description" content="<?php echo $content; ?>" />
    <meta name="keywords" content="<?php echo $key; ?>" />
    <meta name="geo.region" CONTENT="Alpes, Côte d'Azur, Briançon">
    <link rel="icon" type="image/png" href="images/icones/favicon.png" sizes="32x32">
    <!-- META FOR IOS & HANDHELD -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="HandheldFriendly" content="true" />
    <meta name="apple-touch-fullscreen" content="YES" />
    <?php if ($lang !== 'fr') {  ?>
        <base href="<?php echo $domain . $lang . '/'; ?>" />
    <?php  } else { ?>
        <base href="<?php echo $domain; ?>" />
    <?php   }   ?>
    <link href="https://fonts.googleapis.com/css?family=Merriweather+Sans:300i|Nunito|Roboto:300,400" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/sources.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/front.css?ver=<?php echo time(); ?>" media="screen" />

    <!-- Matomo -->
    <script type="text/javascript">
        var _paq = window._paq = window._paq || [];
        /* tracker methods like "setCustomDimension" should be called before "trackPageView" */
        _paq.push(['trackPageView']);
        _paq.push(['enableLinkTracking']);
        (function() {
            var u = "https://matomo.demodirecte.fr/";
            _paq.push(['setTrackerUrl', u + 'matomo.php']);
            _paq.push(['setSiteId', '12']);
            var d = document,
                g = d.createElement('script'),
                s = d.getElementsByTagName('script')[0];
            g.type = 'text/javascript';
            g.async = true;
            g.src = u + 'matomo.js';
            s.parentNode.insertBefore(g, s);
        })();
    </script>
    <!-- End Matomo Code -->

    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-116686904-1"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'UA-116686904-1');
    </script>
</head>

<body>
    <div id="content" class="rel">
        <div id="init"><?php include('includes/content.php'); ?></div>
    </div> <!-- Content -->
    <div id="ajax"></div>

    <div id="footer" class="rel pt2 txtcenter bggrey2 white">
        <div id="footContent" class="table">
            <div class="cell">
                <img id="logoFooter" src="<?php echo $domain; ?>images/main/logo.png" alt="" />
            </div>
            <div class="cell">
                <ul class="w300p ma0">
                    <li class="fs2">Serre Chevalier Holidays</li>
                    <li class="arial">+33 6 75 08 23 19 <span id="dspm" class="ml1 under pointer"><?php echo $tr['homepage']['footer'][$lang][0]; ?></span></li>
                    <li id="footM" class="none under pointer"><a id="msoc" href=""></a></li>
                </ul>
            </div>
        </div>
        <div id="underFooter" class="mt2 bgcyan white">
            <ul class="ma0 pa0 listinline fs14">
                <li><a href="<?php echo $tr['homepage']['footer'][$lang][2]; ?>"><?php echo $tr['homepage']['footer'][$lang][1]; ?></a></li>
                <li><a href="<?php echo $tr['homepage']['footer'][$lang][4]; ?>" rel="nofollow"><?php echo $tr['homepage']['footer'][$lang][3]; ?></a></li>
                <li><a href="<?php echo $tr['homepage']['footer'][$lang][6]; ?>" rel="nofollow"><?php echo $tr['homepage']['footer'][$lang][5]; ?></a></li>
                <li><a href="http://logilink.fr/creation-site-internet/prestations.html">Logilink</a></li>
            </ul>
        </div>
    </div>
    <script type="text/javascript" src="<?php echo $domain; ?>js/jquery.js"></script>
    <script src="https://cdn.rawgit.com/michalsnik/aos/2.1.1/dist/aos.js"></script>
    <script type="text/javascript">
        function scrollToAnchor(aid) {
            var aTag = $("a[name='" + aid + "']");
            $('html,body').animate({
                scrollTop: aTag.offset().top
            }, 1000);
        }

        $(document).ready(function() {

            AOS.init({
                //    disable: 'mobile'
            });

            $('.loc').click(function() {
                var myClass = $(this).attr("class");
                scrollToAnchor('' + myClass);
                $('#skier1').addClass('go1');
                $('#skier2').addClass('go2');
            });

            var lastScrollTop = 0;
            $(window).scroll(function(event) {
                var st = $(this).scrollTop();
                if (st > lastScrollTop) {
                    $('#skier1').addClass('go1');
                    $('#skier2').addClass('go2');
                } else {
                    // upscroll code
                }
                lastScrollTop = st;
            });


            $(function() {
                $("#dspc").click(function(e) {
                    var secret = function() {
                        return atob('Y29udGFjdEBzZXJyZWNoZXZhbGllcmhvbGlkYXlzLmNvbQ==');
                    };
                    $('#post').attr("href", 'mailto:' + secret());
                    $('#post').text(secret());
                    $('#post').off("click");
                    e.preventDefault();
                    if ($("#contact").is(":hidden")) {
                        $("#contact").slideDown('slow');
                        $('#dspc').html('<div class="closeContact fs3">&#128897;</div>');
                    } else {
                        $("#contact").slideUp('slow');
                        $('#dspc').html('Contact');
                    }
                });
            });

            $(function() {
                $("#dspm").click(function(e) {
                    var reveal = function() {
                        return atob('Y29udGFjdEBzZXJyZWNoZXZhbGllcmhvbGlkYXlzLmNvbQ==');
                    };
                    $('#msoc').attr("href", 'mailto:' + reveal());
                    $('#msoc').text(reveal());
                    $('#msoc').off("click");
                    e.preventDefault();
                    if ($("#footM").is(":hidden")) {
                        $("#footM").slideDown('slow');
                    } else {
                        $("#footM").slideUp('slow');
                    }
                    $("html, body").animate({
                        scrollTop: $(document).height()
                    }, 1500);
                });
            });

            $('#contact').on('click', function(e) {
                if ($(e.target).closest("#ulc").length === 0) {
                    $("#contact").slideUp('slow');
                }
            });

            //-------------  LIFT  ----------------

            $('.up').click(function() {
                $('html, body').animate({
                    scrollTop: 0
                }, 800);
                return false;
            });

            $(window).scroll(function() {

                var windowW = $(window).width();
                if (windowW > 500) {
                    if ($(document).scrollTop() > 200) { //Here 200 may be not be exactly 200px
                        $('.up').fadeIn();
                    } else {
                        $('.up').fadeOut();
                    }
                }
            });
        });

        $('#mainmenu li').click(function() {
            $(this).addClass('selected');
            $(this).siblings().removeClass('selected');
        });

        $('#hamb').click(function() {
            $(this).toggleClass('open');
            $('#menu').slideToggle("slow");
            $("#overlay").toggleClass("block");
            $("#overlay").slideToggle("slow");
        });

        $('#langSelect').click(function() {
            $('#langWrapper').slideDown('slow');
        });

        $('#langList li').click(function() {
            $('#langWrapper').slideUp('fast');

            var lang = $(this).attr('class');

            $.post("<?php echo $domain; ?>lang.php", {
                langue: lang
            }, function(data) {
                $('#ajax').html(data);
            });
        });
    </script>
    <?php include('includes/script.php'); ?>
    <script type="text/javascript" src="<?php echo $domain; ?>js/fullcalendar/moment.min.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/jquery.daterangepicker.min.js"></script>
    <script type="text/javascript" src="<?php echo $domain; ?>js/pnotify.min.js"></script>
</body>

</html>