<script type="text/javascript">
  $("html,body").animate({
    scrollTop: 0
  }, 0);

  $(document).ready(function() {

    $('#map').delay('3000').html('<?php echo $map; ?>');

    var distance = $('#bodyCard').offset().top - 40;
    $window = $(window);

    $window.scroll(function() {

      var screenWidth = $(window).width();

      if (screenWidth > 1020) {
        var colWidth = $('#rightCard').outerWidth();
        var margeWidth = ($(window).width() - ($('#rightCard').offset().left + colWidth));

        if ($window.scrollTop() >= distance) {
          $('#bookWrapper').css({
            "position": "fixed",
            "top": "70px",
            "right": margeWidth
          });
          return;

        } else {
          $('#bookWrapper').css({
            "position": "inherit",
            "top": "0",
            "right": "0"
          });
          return;
        }
      }
    });

    $('#dispBook').click(function() {
      $('#mobWrapper').fadeIn('slow');
      $('#closeBook').show();
      $('body').addClass('noScroll');
    });

    $('#closeBook').click(function() {
      $('#mobWrapper').fadeOut('slow');
      $('#closeBook').hide();
      $('body').removeClass('noScroll');
    });


    $('#startBooking').dateRangePicker({
      singleDate: true,
      singleMonth: true,
      format: 'DD/MM/YYYY',
      startDate: moment(),
      endDate: moment.unix(<?php echo $deadline; ?>),
      language: '<?php echo $lang; ?>',
      startOfWeek: 'monday',
      separator: ' - ',
      inline: true,
      container: '#formBook',
      stickyMonths: true,
      selectForward: true,
      extraClass: 'first',
      customOpenAnimation: function(cb) {
        $(this).fadeIn(300, cb);
      },
      customCloseAnimation: function(cb) {
        $(this).fadeOut(300, cb);
      },

      beforeShowDay: function(t) //disabled days
      {
        var jour = moment(t).startOf('day').utcOffset(0, true).unix();
        var tarifs = <?php echo $tarifs; ?>;
        var disabled = <?php echo $disabledDays; ?>;
        var valid = true;

        if (jQuery.inArray(jour, tarifs) == -1) {
          valid = false;
        }
        if (jQuery.inArray(jour, disabled) > -1) {
          valid = false;
        }
        var _class = '';
        var _tooltip = valid ? '' : '';
        return [valid, _class, _tooltip];
      }

    }).bind('datepicker-open', function() {
      $('#startBooking').addClass('focus');
      $('#endBooking').removeClass('focus');
      $('#cursor').show();
      $('#cursor').removeClass('moveRight');

    }).bind('datepicker-change', function(event, obj) {

      var cond = <?php echo $cond; ?>; // Tarifs au jour le jour + conditions
      var periodT = <?php echo $periodT; ?>; // Tarifs par périodes (début/fin de période)

      startBook = '';
      endBook = '';
      currentBook = '';
      autoEndBook = '';
      pickEndBook = '';

      var statut = '';
      var currentStay = '';
      var nextBook = '';
      var millisecBook = '';
      var nextStay = '';
      var checkTime = '';
      var minEndBook = '';
      var startDisplay = '';
      var endDisplay = '';
      var startWeek = <?php echo $startWeek; ?>;
      var startDay = <?php echo $startDay; ?>;

      $('.error-top').css('display', 'none');
      startBook = moment(obj.date1).format("YYYY-MM-DD");

      startBook = moment(startBook).utcOffset(0, true).unix(); // Date au format timestamp de la db
      pickStartBook = moment.unix(startBook, "x").format("YYYY-MM-DD"); // Même date au format string pour comparer avec la date inscrite dans chaque cellule du calendrier

      limitDate = <?php echo $deadline; ?>;

      $.each(<?php echo $disabledDays; ?>, function(i, item) {
        if (item > startBook) {
          limitDate = item; // Prochain jour occupé après la date d'arrivée choisie (interdit tous les jours qui suivent pour éviter une location avec des jours occupés au milieu)
          return false;
        }
      });

      $.each(cond, function(k, v) {

        if (v.start == startBook) { // Quand la date correspond à la date cliquée, on récupère les infos  (tarifs, durée min de séjour)
          currentStay = v.minstay; // Durée minimum de séjour
          var currentDay = moment.unix(startBook).isoWeekday(); // Jour de la semaine correspondant à la date d'arrivée choisie

          if (currentStay == 7) { // Contrôle du jour d'arrivée : Si la durée minimum est de 1 semaine
            var minRef = startWeek;
          } else {
            var minRef = startDay;
          }
          if (minRef != '' && minRef != 0) { // Si le jour d'arrrivée n'est pas indiqué par le propriétaire comme libre
            if (currentDay != minRef) { // Si le jour d'arrivée ne concorde pas avec le jour imposé par le propriétaire
              $.each(periodT, function(key, val) {
                if (startBook >= val.start && startBook <= val.end) { // On recherche la période pour informer des restrictions de durée
                  startAlert = moment.unix(val.start).format("DD/MM/YYYY");
                  endAlert = moment.unix(val.end).format("DD/MM/YYYY");

                  dayNames = ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
                  var jourJ = dayNames[minRef];

                  $('.date-picker-wrapper .footer').html('<div class="infoBook"><span class="picto infoPicto"></span>Du <b>' + startAlert + '</b> au <b>' + endAlert + '</b><br /> arrivées et départs le ' + jourJ + '.</div>');
                  $('.date-picker-wrapper .footer').slideDown('slow');
                }
              });
              return;
            }
          }

          currentBook = moment.unix(v.start).format("YYYY-MM-DD");
          autoEndBook = moment(currentBook).add(currentStay, 'days'); // Calcul de la date de fin correspondant à la durée minimum de séjour ( Date sélectionnée + durée minimum de séjour)
          autoEndBook = moment(autoEndBook).utcOffset(0, true).unix(); // Conversion en timestamp
          pickEndBook = moment.unix(autoEndBook, "x").format("YYYY-MM-DD"); // Même date au format string pour comparer avec la date inscrite dans chaque cellule du calendrier
        }

        if (v.start == autoEndBook) {
          nextStay = v.minstay;
        }
      });

      $(".first").find('.day').each(function() {
        times = moment($(this).attr('time'), "x").format("YYYY-MM-DD"); //  // Date JS en milliseconds de la cellule convertie au format string
        if (times === pickEndBook) {
          if ($(this).hasClass('valid')) { // Si le jour de départ est libre
            if (nextStay > currentStay) { // Si la durée minimum de séjour à cette date est supérieure à celle du jour d'arrivée.
              $.each(periodT, function(key, val) { // Chargement des périodes de tarifs pour trouver dans quelle période de tarifs se situe la date de fin
                if (autoEndBook == val.start) { // Si le jour de départ correspond au jour du changement de durée minimum (les gens se croisent)
                  endBook = autoEndBook;
                } else {
                  if (autoEndBook > val.start && autoEndBook < val.end) { // Si le jour de départ se situe après le jour du changement de durée minimum

                    minEndBook = moment.unix(val.start).format("YYYY-MM-DD");
                    minEndBook = moment(minEndBook).add(nextStay, 'days');
                    minEndBook = moment(minEndBook).utcOffset(0, true).unix();
                    endBook = minEndBook; // On en déduit la nouvelle date de fin (début de la période + nombre de nuits minimum)
                    //  console.log('Allongement de la durée' + endBook);
                    //  console.log(val.start +'/' +autoEndBook)
                  }
                }
              });
            } else // Si la durée minimum de séjour ne change pas (ou est inférieure)
            {
              endBook = autoEndBook;
              statut = 1;
            }
          } else // Si le dernier jour de location n'est pas disponible
          {
            $.each(periodT, function(key, val) { //  Si la durée du séjour est plus courte que le minimum obligatoire (dernier jour indisponible)
              if (startBook >= val.start && startBook <= val.end) { // On recherche la période pour informer des restrictions de durée
                startAlert = moment.unix(val.start).format("DD/MM/YYYY");
                endAlert = moment.unix(val.end).format("DD/MM/YYYY");
                $('.date-picker-wrapper .footer').html('<div class="alertBook ">Date de départ indisponible</div>');
                $('.date-picker-wrapper .footer').slideDown('slow');
              }
            });
            return;
          }
        }
      });

      if (endBook != '') {
        endDisplay = moment.unix(endBook).format("DD/MM/YYYY");
        newStartdate = moment.unix(endBook).format("YYYY-MM-DD");
        newStartdate = moment(newStartdate).utcOffset(0, true).unix();
        pickEndBook = moment.unix(autoEndBook, "x").format("YYYY-MM-DD"); // Même date au format string pour comparer avec la date inscrite dans chaque cellule du calendrier

        $('#endBooking').val(endDisplay);

        $('#startBooking').data('dateRangePicker').close();

        if (document.querySelector('.date-picker-wrapper.last')) {
          $('#endBooking').data('dateRangePicker').destroy(); // Détruire les instances précédentes du picker avant de charger la nouvelle
        }

        $('#endBooking').dateRangePicker({

          singleDate: true,
          singleMonth: true,
          format: 'DD/MM/YYYY',
          startDate: moment(),
          endDate: moment.unix(<?php echo $deadline; ?>),
          startOfWeek: 'monday',
          separator: ' - ',
          stickyMonths: true,
          autoClose: false,
          inline: true,
          container: '#formBook',
          extraClass: 'last',

          customOpenAnimation: function(cb) {
            $(this).fadeIn(300, cb);
          },
          customCloseAnimation: function(cb) {
            $(this).fadeOut(300, cb);
          },

          beforeShowDay: function(t) //disabled days
          {
            var jour = moment(t).startOf('day').utcOffset(0, true).unix();
            var tarifs = <?php echo $tarifs; ?>;
            var disabled = <?php echo $bookList; ?>;
            var valid = true;

            if (jour < moment(newStartdate)) {
              valid = false;
            }

            if (jour > moment(limitDate)) {
              valid = false;
            }

            if (jQuery.inArray(jour, tarifs) == -1) {
              valid = false;
            }
            if (jQuery.inArray(jour, disabled) > -1) {
              valid = false;
            }
            var _class = '';
            var _tooltip = valid ? '' : '';
            return [valid, _class, _tooltip];
          }
        }).bind('datepicker-open', function() {

          if (!$('#cursor').hasClass('moveRight')) {
            $('#cursor').addClass('moveRight');
          }
          $('#startBooking').removeClass('focus');
          $('#endBooking').addClass('focus');


          $(".last").find('.day').each(function() {
            times = moment($(this).attr('time'), "x").format("YYYY-MM-DD");
            if (times === pickStartBook) {
              $(this).addClass('startbook');
            }

            if (times > pickStartBook && times < pickEndBook) {
              $(this).addClass('rangebook');
            }

            if (times === pickEndBook) {
              $(this).addClass('transp');
            }
          });

          var finish = '';

        }).bind('datepicker-change', function(event, obj) {
          event.stopImmediatePropagation();
          newEndBook = moment(obj.date1).format("YYYY-MM-DD");
          newEndBook = moment(newEndBook).utcOffset(0, true).unix(); // Date au format timestamp de la bd
          pickEndBook = moment.unix(newEndBook, "x").format("YYYY-MM-DD"); // Même date au format string pour comparer avec la date inscrite dans chaque cellule du calendrier

          $(".last").find('.day').each(function() {
            times = moment($(this).attr('time'), "x").format("YYYY-MM-DD");
            if (times === pickEndBook) {
              $(this).removeClass('transp');
            }
          });


          $.each(cond, function(k, v) {

            if (v.start == newEndBook) { // Quand la date correspond à la date cliquée, on récupère les infos  (tarifs, durée min de séjour)

              newEndStay = v.minstay; // Durée minimum de séjour
              var newEndDay = moment.unix(newEndBook).isoWeekday(); // Jour de la semaine correspondant à la nouvelle date de départ choisie

              if (newEndStay == 7) { // Contrôle de la zone dans laquelle se trouve le nouveau jour de départ : Si la durée minimum est de 1 semaine
                var minSt = startWeek;
              } else {
                var minSt = startDay;
              }

              if (minSt != '' && minSt != 0) { // Si le jour de départ n'est pas indiqué par le propriétaire comme libre
                if (newEndDay != minSt) { // Si le jour d'arrivée ne concorde pas avec le jour imposé par le propriétaire
                  $.each(periodT, function(key, val) {
                    if (newEndBook >= val.start && newEndBook <= val.end) { // On recherche la période pour informer des restrictions de durée
                      startAlert = moment.unix(val.start).format("DD/MM/YYYY");
                      endAlert = moment.unix(val.end).format("DD/MM/YYYY");

                      $('#endBooking').val(endDisplay);

                      dayNames = ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
                      var jourJ = dayNames[minSt];

                      $('.date-picker-wrapper .footer').html('<div class="alertBook ">Date de départ indisponible</div>' +
                        '<div class="infoBook"><span class="picto infoPicto"></span>Du <b>' + startAlert + '</b> au <b>' + endAlert + '</b><br /> arrivées et départs le ' + jourJ + '.</div>');
                      $('.date-picker-wrapper .footer').slideDown('slow');
                    }
                  });

                  $(".last").find('.day').each(function() {
                    times = moment($(this).attr('time'), "x").format("YYYY-MM-DD"); //  // Date JS en milliseconds de la cellule convertie au format string
                    if (times === pickEndBook) {
                      $(this).addClass('wrong');
                    }
                  });

                  finish = 0;
                } else {
                  finish = 1;
                }
              } else {
                finish = 1;
              }
            }
          });
          if (finish === 1) {
            $('#endBooking').data('dateRangePicker').close();

            var nbChilds = parseInt($('#adult').val());
            var nbAdults = parseInt($('#child').val());
            var nbTenants = nbChilds + nbAdults;

            $.post("<?php echo  $domain; ?>ajax/tarifs.php", {
              sourceID: <?php echo $sourceID; ?>,
              start: $('#startBooking').val(),
              end: $('#endBooking').val(),
              tenants: nbTenants
            }, function(data) {
              $('#ajax').html(data);
            });
          }
        });

        $('#endBooking').data('dateRangePicker').open();
      }

      $('#cursor').addClass('moveRight');
    });
  });

  function scrollTo(hash) {
    location.hash = "#" + hash;
  }

  $('.details, .equ, .lois, .geo').click(function() {
    var myClass = $(this).attr("class");
    scrollTo(myClass);
  });

  $('.add').click(function() {
    var cap = <?php echo $cap; ?>;
    var adults = parseInt($('#adult').val());
    var childs = parseInt($('#child').val());

    var input = $(this).prev().find('input');
    var value = $(this).prev().find('input').val();
    var sendVal = $('#tenants').val();

    if (adults + childs < cap) {
      $(this).prev().find('input').val(++value);
      $('#tenants').val(++sendVal);
    }

    if ($('#startBooking').val() != '' && $('#endBooking').val() != '') {
      $.post("<?php echo  $domain; ?>ajax/tarifs.php", $('#bookWrapper').serializeArray(), function(data) {
        $('#ajax').html(data);
      });
    }
  });

  $('.remove').click(function() {
    var adults = parseInt($('#adult').val());
    var childs = parseInt($('#child').val());

    var input = $(this).next().find('input').attr('id');
    var sendVal = $('#tenants').val();

    if (input === 'adult') {
      if (adults > 1) {
        $('#adult').val(--adults);
        $('#tenants').val(--sendVal);
      }
    } else {
      if (childs > 0) {
        $('#child').val(--childs);
        $('#tenants').val(--sendVal);
      }
    }

    if ($('#startBooking').val() != '' && $('#endBooking').val() != '') {
      $.post("<?php echo  $domain; ?>ajax/tarifs.php", $('#bookWrapper').serializeArray(), function(data) {
        $('#ajax').html(data);
      });
    }
  });

  $('#validBook').click(function() {
    $(this).closest("form").submit();
  });

  $('#startBooking').click(function() {
    $('.date-picker-wrapper .footer').slideUp();
  });

  $('.showSlide').click(function() {
    $.post("<?php echo  $domain; ?>ajax/slider.php", {
      sourceID: <?php echo $sourceID; ?>
    }, function(data) {
      $('#ajax').html(data);
    });
  });
</script>