<div id="fiche" class="bgf9">
  <?php

  $sourceID = substr(strrchr($page, "-"), 1);

  $_SESSION['sourceID'] = $sourceID;

  $tarifs = array();
  $filterPrices = array();
  $cond = array();
  $bookList = array();
  $periodT = array();
  $group = array();
  $tarifGroup = array();

  foreach ($rentals as $key => $r) {
    if ($sourceID == $r['RID']) {
      $rental = $r['RID'];  // Location  affichée
      $property = $r['PID'];  // Propriété de la location
      $master = $r['master']; // Type de bien (avec ou sans sous-location)
      break;
    }
  }

  if ($master == 0) {   // Sous-bien d'une location principale
    foreach ($rentals as $key => $r) {
      if ($r['PID'] == $property && ($r['master'] == 1 || $r['RID'] == $rental)) {
        $group[] = $r['RID'];
      }
    }
  }

  if ($master == 1) {   // Bien principal contenant des sous-locations
    foreach ($rentals as $key => $r) {
      if ($r['PID'] == $property) {
        $group[] = $r['RID']; // Pour les dates de booking, toutes les locations, bien entier compris
        if ($r['RID'] != $rental) {
          $tarifGroup[] = $r['RID'];  // Pour le calcul des tarifs, toutes les locations moins le bien entier (master), son tarif étant déduit de la somme des sous-locations
        }
      }
    }
  }

  $cg = count($group);

  if ($cg > 1) {
    $groupList = implode("','", $group);
    $groupList = "'" . $groupList . "'";
    $TG = implode("','", $tarifGroup);
    $TG = "'" . $TG . "'";
  } else {
    $groupList = implode("", $group);
  }

  if ($master != 1) {
    $query = $sql->run('SELECT start,day,week,minstay FROM tarifs WHERE tarifID="' . $sourceID . '" AND periodID!=0 ORDER BY start ASC');
  } else {
    $query = $sql->run('SELECT start,day,week,minstay FROM tarifs WHERE tarifID IN(' . $TG . ') AND periodID!=0 ORDER BY start ASC');
  }

  while ($r = $query->fetch()) {
    $tarifs[] = $r['start'];
    $filterPrices[] = $r['day'];
    $tarif_det = array();
    $tarif_det['start'] = $r['start'];
    $tarif_det['minstay'] = $r['minstay'];
    $cond[] = $tarif_det;
  }

  if ($master == 1) {
    $minPrice = 0;

    foreach ($group as $val) {
      $query = $sql->run('SELECT day FROM tarifs WHERE tarifID="' . $val . '" ORDER BY day ASC LIMIT 1')->fetch();
      if ($query) {
        $minPrice += $query['day'];
      }
    }
  } else {
    $minPrice = min($filterPrices);
  }


  $cond = json_encode($cond, JSON_NUMERIC_CHECK);

  $query = $sql->run('SELECT start,end FROM tarifs WHERE tarifID="' . $sourceID . '" AND periodID=0 ORDER BY start ASC');

  while ($r = $query->fetch()) {

    $periods = array();
    $periods['start'] = $r['start'];
    $periods['end'] = $r['end'];
    $periodT[] = $periods;
  }

  $periodT = json_encode($periodT, JSON_NUMERIC_CHECK);

  /*-----------------------   BOOKING -------------------------------*/

  $singleDays = array();
  $today = strtotime('12:00:00');
  $starting = strtotime("-1 month"); // 1 mois avant la date du jour
  $starts = array();
  $ends = array();
  $oneD = array();

  if ($master > 1) {
    $query = $sql->run('SELECT start FROM booklist WHERE sourceID ="' . $rental . '" AND start >=' . $starting . ' ORDER BY start ASC');
    while ($r = $query->fetch()) {
      $bookList[] = $r['start'];
    }

    /*------------------  Jours isolés  ----------------*/

    $query = $sql->run('SELECT start, end FROM booking WHERE sourceID="' . $rental . '" ORDER BY start ASC');
    while ($r = $query->fetch()) {
      $starts[] =  $r['start'];
      $oneDless[] =  $r['start'] - 86400;
      $oneDmore[] =  $r['end'] + 86400;
      $ends[] = $r['end'];
    }
  } else {
    $query = $sql->run('SELECT start FROM booklist WHERE sourceID IN(' . $groupList . ') AND start >=' . $starting . ' ORDER BY start ASC');
    while ($r = $query->fetch()) {
      $bookList[] = $r['start'];
    }

    /*------------------  Jours isolés  ----------------*/

    $i = 0;

    $query = $sql->run('SELECT start, end FROM booking WHERE sourceID IN(' . $groupList . ') AND start >=' . $starting . ' ORDER BY start ASC');
    while ($r = $query->fetch()) {
      $starts[] =  $r['start'];

      $oneDless[] =  $r['start'] - 86400;
      $oneDmore[] =  $r['start'] + 86400;

      $oneD[$i]['start'] = $r['start'];
      $oneD[$i]['less'] = $r['start'] - 86400;
      $oneD[$i]['more'] = $r['start'] + 86400;

      $ends[] = $r['end'];
      $i++;
    }
  }

  foreach ($oneD as $o) {
    if (in_array($o['less'], $bookList) && in_array($o['more'], $bookList)) {
      $singleDays[] = $o['start'];
    }
  }

  $startWeek = '';
  $startday = '';

  foreach ($locationID as $val) {
    if ($val['id'] == $sourceID) {
      $startWeek = $val['startWeek'];
      $startDay = $val['startDay'];
      $cap = $val['cap'];
      $fee = $val['fee'];
      $deadline = $val['deadline'];
    }
  }

  $occupied = array_merge($bookList, $singleDays);
  $bookList = json_encode($bookList, JSON_NUMERIC_CHECK);
  $tarifs = json_encode($tarifs, JSON_NUMERIC_CHECK);
  $disabledDays = json_encode($occupied, JSON_NUMERIC_CHECK);

  $query = $sql->run('SELECT pano FROM interlink WHERE rentID="' . $sourceID . '"');
  $r = $query->fetch();
  ?>

  <div id="headerCard" class="rel headerPage txtcenter bggrey1 white">
    <a href="<?= $domain ?>">
      <div id="backHome" class="abs white pointer"><?php echo $tr['fiche']['back'][$lang]; ?></div>
    </a>
    <ul id="menuCard" class="inbl menu ma0 pa0 listinline txtcenter roboto">
      <li class="details"><?php echo $tr['fiche']['link'][$lang][1]; ?></li>
      <li class="equ"><?php echo $tr['fiche']['link'][$lang][2]; ?></li>
      <li class="lois"><?php echo $tr['fiche']['link'][$lang][3]; ?></li>
      <li class="geo"><?php echo $tr['fiche']['link'][$lang][4]; ?></li>
      <li></li>
    </ul>
    <div id="langSelect" class="lngSelB <?php echo $lang; ?>"><?php echo $lang; ?></div>
    <div id="langWrapper" class="abs none bgc2">
      <ul id="langList" class="pl1 pt1 pb1 ma0 just">
        <li class="fr">Français</li>
        <li class="en">English</li>
        <li class="it">Italiano</li>
        <li class="sp">Español</li>
        <li class="de">Deutsch</li>
        <li class="nl">Nederlands</li>
      </ul>
    </div>
    <div id="contactPage" class="abs bggrey3 white pointer"><span id="dspc" class="block h100">Contact</span></div>
    <div id="contact" class="none bggrey3 white txtcenter">
      <ul id="ulc" class="rel ma0 pa0 inbl center listinline">
        <li class="arial">+33 6 75 08 23 19</li>
        <li class="post ml2 under pointer"><a id="post" href="mailto:contact@serrechevalierholidays.com">Nous contacter</a></li>
      </ul>
    </div>
  </div>
  <section>
    <div id="panoCard<?php echo $sourceID; ?>" class="w100 panoCard flex flexM  flexC txtcenter">
      <div class="rel inbl">
        <img id="topPicture" src="<?php echo $domain; ?>images/annonces/pano/<?php echo $sourceID . '/' . $r['pano']; ?>" alt="Alpes Serre Chevalier" data-aos="zoom-in" data-aos-duration="1200" data-aos-once="true" />
        <div id="showSlide" class="abs showSlide pointer bgc2 txtright pr2" data-aos="flip-left" data-aos-duration="1500" data-aos-once="true"><?php echo $tr['fiche']['link'][$lang][0]; ?></div>
      </div>
    </div>
  </section>

  <div class="pt1 pb1">
    <div id="pictofiche" class="table arial fs14 center txtcenter">
      <?php
      $query = $sql->run('SELECT * FROM estate WHERE estID="' . $sourceID . '"');
      $r = $query->fetch();

      $map = $r['map'];
      $capa = $r['capa'];
      $chambres = $r['chambres'];
      $prop = $r['nom_pub'];

      $picto = '<div data-aos="flip-left" data-aos-duration="1500" data-aos-once="true">
          <div class="planfiche"></div>
          <div class="pictoText"><p>' . $tr['fiche']['iconView'][$lang][0] . '</p><p class="pictonumber">' . $r['surf'] . ' m²</p></div>
          </div>';

      if (!empty($r['capa'])) {
        $picto .= '<div data-aos="flip-left" data-aos-duration="1500" data-aos-once="true">
            <div class="capafiche"></div>
            <div class="pictoText"><p>' . $tr['fiche']['iconView'][$lang][1] . '</p><p class="pictonumber">' . $r['capa'] . '</p></div>
            </div>';
      }

      if (!empty($r['chambres'])) {
        $picto .= '<div data-aos="flip-left" data-aos-duration="1500" data-aos-once="true">
            <div class="roomfiche"></div>
            <div class="pictoText"><p>' . $tr['fiche']['iconView'][$lang][2] . '</p><p class="pictonumber">' . $r['chambres'] . '</p></div>
            </div>';
      }

      if (!empty($r['lits'])) {
        $picto .= '<div data-aos="flip-left" data-aos-duration="1500" data-aos-once="true">
            <div class="bedfiche"></div>
            <div class="pictoText"><p>' . $tr['fiche']['iconView'][$lang][3] . '</p><p class="pictonumber">' . $r['lits'] . '</p></div>
            </div>';
      }

      if (!empty($r['sdb'])) {
        $picto .= '<div data-aos="flip-left" data-aos-duration="1500" data-aos-once="true">
            <div class="bathfiche"></div>
            <div class="pictoText"><p>' . $tr['fiche']['iconView'][$lang][4] . '</p><p class="pictonumber">' . $r['sdb'] . '</p></div>
            </div>';
      }
      echo '<div id="picto" class="clear center txtcenter">' . $picto . '</div>';
      ?>
    </div>
  </div>
  <div id="bodyCard" class="rel flex mediumPage bgfff">
    <a id="details" class="anchor"></a>
    <div id="leftCard" class="w70 bgfff">
      <h1 class="txtcenter merri fs3"><?php echo $tr['homepage']['screen2']['rentName'][$lang][$sourceID - 1]; ?></h1>
      <div id="desc" class="cardSection">
        <div id="headPageContact" class="flex flexM center fs2 bgf7">
          <p class="mt0"><span class=""> +33 </span>&nbsp;6 75 08 23 19</p>
          <p class="pageMail mt0"><a href="mailto:contact@serrechevalierholidays.com"><?php echo $tr['homepage']['footer'][$lang][0]; ?></a></p>
        </div>
        <h3 class="titleFont merri fs25 cyan" data-aos="fade-left" data-aos-duration="1000" data-aos-once="true">
          <?php
          $type = strtolower($r['type']);

          switch ($type) {
            case 'appartement':
              $typeRent = $tr['fiche']['rentType'][$lang][0];
              break;
            case 'chalet':
              $typeRent = $tr['fiche']['rentType'][$lang][1];
              break;
            case 'maison':
              $typeRent = $tr['fiche']['rentType'][$lang][2];
              break;
            default:
              $typeRent = $tr['fiche']['rentType'][$lang][3];
              break;
          }
          echo $typeRent;
          ?>
        </h3>
        <div id="description" class="pt2"><?php echo $r['desc_' . $lang]; ?></div>

        <h4 id="lounge" class="elemTitle bluegrey" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][0]; ?></h4>
        <div class="sectionGrey" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $r['salon_' . $lang]; ?></div>

        <h4 id="rooms" class="elemTitle bluegrey" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][1]; ?></h4>
        <div><?php echo $r['room_' . $lang]; ?></div>

        <h4 id="bathrooms" class="elemTitle bluegrey" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][2]; ?></h4>
        <div class="sectionGrey" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $r['bath_' . $lang]; ?></div>

        <?php
        if (!empty(trim($r['comfort_fr']))) {
        ?>
          <h4 id="comfort" class="elemTitle bluegrey" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][3]; ?></h4>
          <div class="sectionGrey" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $r['comfort_' . $lang]; ?></div>

        <?php }  ?>
        <h4 id="exteriors" class="elemTitle bluegrey" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][4]; ?></h4>
        <ul class="pl1">
          <?php

          if ($r['swim'] != 0) {
            echo '<li>' . $tr['fiche']['outdoor'][$lang][7] . '</li>';
          }

          if ($r['swimC'] != 0) {
            echo '<li>' . $tr['fiche']['outdoor'][$lang][8] . '</li>';
          }

          if ($r['terrasse'] != 0) {
            if ($r['terrasse'] == 1) {
              $out1 = $tr['fiche']['outdoor'][$lang][0];
              echo '<li>' . $out1 . '</li>';
            } else {
              $out1 = $tr['fiche']['outdoor'][$lang][1];
              echo '<li>' . $r['terrasse'] . ' ' . $out1 . '</li>';
            }
          }

          if ($r['garden'] != 0) {
            echo '<li>' . $tr['fiche']['outdoor'][$lang][2] . '</li>';
          }

          if ($r['park'] != 0) {
            if ($r['park'] == 1) {
              $out2 = $tr['fiche']['outdoor'][$lang][3];
              echo '<li>' . $out2 . '</li>';
            } else {
              $out2 = $tr['fiche']['outdoor'][$lang][4];
              echo '<li>' . $r['park'] . ' ' . $out2 . '</li>';
            }
          }

          if ($r['garage'] != 0) {
            if ($r['garage'] == 1) {
              $out3 = $tr['fiche']['outdoor'][$lang][4];
              echo '<li>' . $out3 . '</li>';
            } else {
              $out3 = $tr['fiche']['outdoor'][$lang][5];
              echo '<li>' . $r['garage'] . ' ' . $out3 . '</li>';
            }
          }

          ?>
        </ul>
      </div>
      <a id="equ" class="anchor"></a>
      <div id="equi" class="cardSection">
        <h3 class="titleFont merri fs25 cyan" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][5]; ?></h3>

        <?php
        $equip = array();
        $equipments = $tr['fiche']['features'][$lang];

        $query = $sql->run('SELECT * FROM equipment WHERE estateID="' . $sourceID . '" ORDER BY id');
        $r = $query->fetchAll(PDO::FETCH_ASSOC);

        foreach ($r as $key => $value) {
          foreach ($value as $key => $val) {
            $equip[] = $val;
          }
        }

        $eq = array_combine($equipments, $equip);

        ?>

        <div class="w100">
          <h4 id="electro" class="elemTitle" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][6]; ?></h4>
          <div class="flex itemDiv sectionGrey">
            <?php
            $electro = $tr['fiche']['electro'][$lang];
            foreach ($eq as $key => $val) {
              if (in_array($key, $electro)) {
                if ($val == 1) {
                  echo '<div class="element">' . $key . '</div>';
                }
              }
            }
            ?>
          </div>
        </div>

        <div class="w100">
          <h4 id="tv" class="elemTitle" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][7]; ?></h4>
          <div class="clear itemDiv pb2">
            <?php
            $internet = $tr['fiche']['internet'][$lang];

            foreach ($eq as $key => $val) {
              if (in_array($key, $internet)) {
                if ($val == 1) {
                  echo '<div class="element left">' . $key . '</div>';
                }
              }
            }
            ?>
          </div>
        </div>
        <div class="w100 mb3">
          <h4 id="divers" class="elemTitle" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][8]; ?></h4>
          <div class="clear itemDiv sectionGrey">
            <?php
            $divers = $tr['fiche']['divers'][$lang];

            foreach ($eq as $key => $val) {
              if (in_array($key, $divers)) {
                if ($val == 1) {
                  echo '<div class="element left">' . $key . '</div>';
                }
              }
            }
            ?>
          </div>
        </div>
      </div>
      <a id="lois" class="anchor"></a>
      <div id="loisirs" class="cardSection">
        <h3 class="titleFont merri fs25 cyan" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][9]; ?></h3>
        <div class="w100">
          <h4 id="nature" class="elemTitle"><?php echo $tr['fiche']['featTitle'][$lang][10]; ?></h4>
          <div class="clear itemDiv pb2">
            <?php
            $cadre =  $tr['fiche']['cadre'][$lang];

            foreach ($eq as $key => $val) {
              if (in_array($key, $cadre)) {
                if ($val == 1) {
                  echo '<div class="element left">' . $key . '</div>';
                }
              }
            }
            ?>
          </div>
        </div>
        <div class="w100 mb2">
          <h4 id="sports" class="elemTitle" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][11]; ?></h4>
          <div class="clear itemDiv sectionGrey">
            <?php
            $loisirs = $tr['fiche']['loisirs'][$lang];

            foreach ($eq as $key => $val) {
              if (in_array($key, $loisirs)) {
                if ($val == 1) {
                  echo '<div class="element left">' . $key . '</div>';
                }
              }
            }
            ?>
          </div>
        </div>
      </div>
      <a id="geo" class="anchor"></a>
      <div class="cardSection">
        <h3 class="titleFont merri fs25 cyan" data-aos="fade-right" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"><?php echo $tr['fiche']['featTitle'][$lang][12]; ?></h3>
        <div id="map" class="w100 mt3 mb3" data-aos="flip-up" data-aos-duration="1000" data-aos-anchor-placement="top-bottom" data-aos-once="true"></div>
      </div>
    </div>
    <div id="rightCard" class="rel">
      <div id="mobWrapper">
        <p class="mt0 mb2 arial fs25 txtcenter"><?php echo $tr['fiche']['engine'][$lang][0]; ?> <b><?php echo $minPrice; ?> €</b> <?php echo $tr['fiche']['engine'][$lang][1]; ?></p>
        <form id="bookWrapper" method="post" action="<?php echo $tr['content'][$lang][5]; ?>" class="txtcenter shadow2">

          <h3 class="roboto fs25 txtcenter mb0 pt2 pb2 bgf2 bggrey3 white"><?php echo $tr['fiche']['engine'][$lang][2]; ?></h3>
          <div id="formBook" class="center bgfa">
            <div id="pickers" class="rel clear">
              <div id="cursor" class="none"></div>
              <input type="text" name="start" class="left inputDate arial fs18 rad3" value="" placeholder="<?php echo $tr['fiche']['engine'][$lang][3]; ?>" id="startBooking">
              <input type="text" name="end" class=" right inputDate arial fs18 rad3" value="" placeholder="<?php echo $tr['fiche']['engine'][$lang][4]; ?>" id="endBooking">
            </div>
            <div id="travelers" class="pt2">
              <div id="tabTenants" class="bgfff pt1 pl1 pr1 pb1">
                <table class="w80 center">
                  <tr>
                    <td class="tenantTitle" colspan="3"><?php echo $tr['fiche']['engine'][$lang][5]; ?></td>
                    <td></td>
                    <td class="tenantTitle" colspan="3"><?php echo $tr['fiche']['engine'][$lang][6]; ?></td>
                  </tr>
                  <tr>
                    <td class="remove">
                      <div></div>
                    </td>
                    <td class="tenants">
                      <div><input type="text" id="adult" name="adult" value="1" /></div>
                    </td>
                    <td class="add">
                      <div></div>
                    </td>
                    <td class="inter">
                      <div></div>
                    </td>
                    <td class="remove">
                      <div></div>
                    </td>
                    <td class="tenants">
                      <div><input type="text" id="child" name="child" value="0" /></div>
                    </td>
                    <td class="add">
                      <div></div>
                    </td>
                  </tr>
                  <tr>
                    <td colspan="7" class="pt1 fs14 txtcenter cyan2"><?php echo $cap; ?> <?php echo $tr['fiche']['engine'][$lang][7]; ?></td>
                  </tr>
                </table>
              </div>
            </div>
          </div>
          <div id="bookTarifs" class="none bgfff">
            <table id="retailPrice" class="w100">
              <tr>
                <td id="heberg" class="pt2"></td>
                <td id="dispPrice" class="pt2 arial bold"></td>
              </tr>
              <tr>
                <td><?php echo $tr['fiche']['engine'][$lang][8]; ?></td>
                <td id="dispCleaning" class="arial bold"></td>
              </tr>
              <?php if ($fee != 0) {  ?>
                <tr>
                  <td id="fee" class="pb1"><?php echo $tr['fiche']['engine'][$lang][9]; ?> (<?php echo $fee; ?> € / pers)</td>
                  <td id="dispTaxes" class="arial bold"></td>
                </tr>
              <?php   }   ?>
            </table>
            <table id="totalPrice" class="w100">
              <tr>
                <td>Total</td>
                <td id="dispTotal" class="arial bold cyan2"></td>
              </tr>
              <tr>
                <td colspan="2" class="txtcenter">
                  <div class="rel">
                    <div id="validBook" class="buttonSquare azure"><i class="abs fa fa-check"></i><span><?php echo $tr['fiche']['engine'][$lang][10]; ?></span></div>
                  </div>
                </td>
              </tr>
            </table>
          </div>
          <p id="legendBook" class="mt0 pa2 just fs14 bgfa"><?php echo $tr['fiche']['engine'][$lang][11]; ?></p>
          <input type="hidden" name="sourceID" value="<?php echo $sourceID; ?>" />
          <input type="hidden" name="prop" value="<?php echo $prop; ?>" />
          <input type="hidden" name="capa" value="<?php echo $capa; ?>" />
          <input type="hidden" name="rooms" value="<?php echo $chambres; ?>" />
          <input type="hidden" name="propName" id="propName" value="" />
          <input type="hidden" name="period" id="period" value="" />
          <input type="hidden" name="loyer" id="loyer" value="" />
          <input type="hidden" name="taxe" id="taxe" value="" />
          <input type="hidden" name="cleaning" id="cleaning" value="" />
          <input type="hidden" name="total" id="total" value="" />
          <input type="hidden" name="tenants" id="tenants" value="" />
        </form>
        <div id="closeBook" class="none bggrey3">
          <div class="center white pointer rad3"><?php echo $tr['fiche']['engine'][$lang][14]; ?></div>
        </div>
      </div>
      <div id="dispBook" class="bggrey3">
        <div class="center white pointer rad3"><?php echo $tr['fiche']['engine'][$lang][15]; ?></div>
      </div>
    </div>
  </div>
</div>