<div id="resa">
    <?php
    include('../../data/data.php');
    setlocale(LC_TIME, 'fr_FR', 'fra');



    $query = $sql->run('SELECT * FROM booking WHERE statut=0 ORDER BY sourceID ASC, datebook DESC');
    $count = $query->rowCount();

    if ($count != 0) {
    ?>
        <div class="cadre mt3 bgfff">
            <p id="chrono" class="h2 fs2 deepgrey">Réservations en attente</p>

            <?php
            while ($r = $query->fetch()) {

                $year = strftime("%Y", $r['start']);
                $timestamp = strtotime('-1 day', $r['end']);
                $start = utf8_encode(strftime("%d %B", $r['start']));
                $end = utf8_encode(strftime("%d %B", $timestamp));
                $resaday = utf8_encode(strftime("%d %B %Y &agrave; %Hh %M", $r['datebook']));
                $startResa = date("d/m/Y", $r['start']);
                $endResa = date("d/m/Y", $r['end']);
                $phone = chunk_split($r['phone'], 2, ' ');
            ?>

                <div class="rel rent mt3">
                    <form>
                        <div class="clear rentTitle pl2 bgv1 white">
                            <div class="right reject tooltips" title="Supprimer" data_id="<?php echo $r['id']; ?>"></div>
                            <div class="right h100 addcal tooltips" title="Ajouter au calendrier" data_id="<?php echo $r['id']; ?>"><img src="<?php echo $domain; ?>images/icones/cal.png" /></div>
                            <div class="right h100 openMail tooltips" title="R&eacute;pondre par mail" data_id="<?php echo $r['id']; ?>"></div>
                            <div class="right h100 pl2 pr2 bgc2 white"><?php echo $r['property'] . ' / ' . $r['rent']; ?></div>
                            <div class="dategrid left w350p h100 txtcenter bgg2"><?php echo $start . ' &nbsp;-&nbsp; ' . $end . ' &nbsp;&nbsp ' . $year ?></div>
                        </div>
                        <div class="pb1 mb3 bgfff">
                            <input type="hidden" name="form" value="validResa" />
                            <input type="hidden" name="resaID" value="<?php echo $r['id']; ?>" />
                            <input type="hidden" name="start" value="<?php echo $startResa; ?>" />
                            <input type="hidden" name="end" value="<?php echo $endResa; ?>" />
                            <input type="hidden" name="resaDay" value="<?php echo $r['datebook']; ?>" />

                            <div class="rel shadow1 pb1 mb3 bgfff">
                                <?php
                                $adult = $r['adult'] . ' adultes';
                                $child = $r['child'] . ' enfants';
                                ?>
                                <table class="gridbook uptab tabresa">
                                    <thead>
                                        <tr>
                                            <th class="tenant"> <?php echo $adult . ' + ' . $child . '<br />'; ?></th>
                                            <th>Coordonnées</th>
                                            <th>Loyer</th>
                                            <th>Ménage</th>
                                            <th>Origine</th>
                                            <th>Message</th>
                                        </tr>
                                    </thead>
                                    <tbody class="list">
                                        <tr>
                                            <td class="rel tenant white txtcenter">
                                                <ul class="inbl mt0 pl0">
                                                    <li><?php echo $r['firstname'] . ' ' . $r['lastname']; ?></li>
                                                    <li><?php echo $phone; ?></li>
                                                    <li class="replyTo"><?php echo $r['email']; ?></li>
                                                </ul>
                                            </td>
                                            <td>
                                                <ul class="mt0 pl0 txtcenter">
                                                    <?php if ($r['address1'] != '') { ?>
                                                        <li><?php echo $r['address1']; ?></li>
                                                    <?php
                                                    }
                                                    if ($r['address2'] != '') {
                                                    ?>
                                                        <li><?php echo $r['address2']; ?></li>
                                                    <?php
                                                    }
                                                    if ($r['city'] != '' || $r['zipcode'] != '') {
                                                    ?>
                                                        <li><?php echo $r['zipcode'] . ' ' . $r['city']; ?></li>
                                                    <?php
                                                    }
                                                    if ($r['zipcode'] != '') {
                                                    ?>
                                                        <li><?php echo $r['state']; ?></li>
                                                    <?php
                                                    }
                                                    if ($r['country'] != '') {
                                                    ?>
                                                        <li><?php echo $r['country']; ?></li>
                                                    <?php } ?>
                                                </ul>
                                            </td>
                                            <td class="txtcenter">
                                                <?php
                                                if ($r['loyer_t'] != '') {
                                                    echo $r['loyer_t'] . ' € <br />';
                                                }
                                                ?>
                                            </td>
                                            <td class="txtcenter">
                                                <?php
                                                if ($r['cleaning'] != '') {
                                                    echo $r['cleaning'] . ' €';
                                                }
                                                ?>
                                            </td>
                                            <?php
                                            foreach ($channelsID as $val) {
                                                if ($val['id'] == $r['origine']) {
                                                    if ($val['nom'] == 'SCH') {
                                                        $channelName = 'Serre-Chevalier Holidays';
                                                    } else {
                                                        $channelName = $val['nom'];
                                                    }
                                                    break;
                                                }
                                            }
                                            ?>
                                            <td><?php echo $channelName; ?></td>
                                            <td class="rel resaMess"><?php echo $r['message']; ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </form>
                </div>
            <?php
            }
            ?>
        </div>
    <?php } ?>

    <div class="cadre mt3 bgfff">
        <a name="resa"></a>
        <p id="reserv" class="h2 fs2 mb0 deepgrey">Réservations traitées</p>
        <div id="reservation">

            <?php
            $today = new DateTime();
            $limit = $today->getTimestamp();

            $sql->run('UPDATE booking SET statut = "1" WHERE end < "' . $limit . '"');

            $year = '';
            $month = '';
            $newyear = 0;
            $newmonth = 0;
            $i = 0;

            $query = $sql->run('SELECT * FROM booking WHERE statut IN(1,2,4) ORDER BY start DESC, property ASC,rent ASC');

            while ($r = $query->fetch()) {

                $id = $r['id'];

                if ($i % 2 == 1) {
                    $css = 'bgf2';
                } else {
                    $css = '';
                }

                $timestamp = strtotime($r['end']);
                $start = utf8_encode(strftime("%d/%m", $r['start']));
                $end = utf8_encode(strftime("%d/%m", $r['end']));
                $phone = chunk_split($r['phone'], 2, ' ');

                $checkAc = '';
                $acompte = '';
                $checkSo = '';
                $solde = '';

                if ($r['acompte'] > 0) {
                    $checkAc = 'approved';
                    $acompte = $r['acompte'] . ' €';
                }

                if ($r['solde'] > 0) {
                    $checkSo = 'approved';
                    $solde = $r['solde'] . ' €';
                }


                foreach ($channelsID as $val) {
                    if ($val['id'] == $r['origine']) {
                        if ($val['nom'] == 'SCH') {
                            $channelName = 'Serre-Chevalier Holidays';
                        } else {
                            $channelName = $val['nom'];
                        }
                        break;
                    }
                }

                $annulcss = "";

                switch ($r['statut']) {
                    case '1':
                        $statcss = 'option';
                        break;
                    case '2':
                        $statcss = 'booked';
                        break;
                    case '4':
                        $statcss = 'aborted';
                        $annulcss = "cancelled";
                        break;
                    default:
                        $statcss = 'bggrey1';
                        break;
                }

                if ($year != strftime("%Y", $r['start'])) {
                    if ($newyear != 0) {
                        echo '</td></tr></table>';
                    }
                    $year = strftime("%Y", $r['start']);
                    $newyear = 1;
            ?>
                    <h1 class="mt3 mb1 txtcenter cyan2"><?php echo $year; ?></h1>
                    <table class="w100 resa">
                        <tr>
                            <td>
                            <?php
                        }

                        if ($month != utf8_encode(strftime("%B", $r['start']))) {
                            if ($newmonth != '') {
                                echo '</table>';
                            }
                            $month = utf8_encode(strftime("%B", $r['start']));
                            ?>

                                <table class="listResa w100 mb3">
                                    <thead>
                                        <tr class="rel bggrey2 white">
                                            <th colspan="11" class="rel">
                                                <div class="left bgrust w200p"><?php echo ucfirst($month) . ' ' . $year; ?></div>
                                                <div class="left w350p pl3 pr3 bgorange"><?php echo $r['property']; ?></div>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr class="bggrey3 white">
                                            <td class="w50p"></td>
                                            <td class="w150p">Location</td>
                                            <td class="w100p">Check In</td>
                                            <td class="w100p">Check Out</td>
                                            <td class="w250p">Locataire</td>
                                            <td class="w100p txtcenter">Loyer stand</td>
                                            <td class="w100p txtcenter">Loyer réel</td>
                                            <td class="w100p">Acompte</td>
                                            <td class="w100p">Solde</td>
                                            <td class="w200p">Origine</td>
                                            <td class="">Pub</td>
                                            <td class="resaTools"></td>
                                        </tr>
                                    <?php }  ?>

                                    <tr id="bgstat<?php echo $id; ?>" class="<?php echo $css . ' ' . $annulcss; ?>">
                                        <td id="stat<?php echo $id; ?>" class="rel <?php echo $statcss; ?> white"></td>
                                        <td><?php echo $r['rent']; ?></td>
                                        <td><?php echo $start; ?></td>
                                        <td><?php echo $end; ?></td>
                                        <td id="name<?php echo $id; ?>"><?php echo $r['firstname'] . ' ' . $r['lastname']; ?></td>
                                        <td class="txtcenter arial bold">
                                            <?php
                                            $decimLt = "0" . strstr($r['loyer_t'], '.');

                                            if ($decimLt == 0) {
                                                $loyerT = number_format($r['loyer_t'], 0, ',', ' ');
                                            } else {
                                                $loyerT = number_format($r['loyer_t'], 2, ',', ' ');
                                            }

                                            echo $loyerT . ' €'; ?></td>
                                        <td id="prixNego<?php echo $id; ?>" class="txtcenter arial rust bold"><?php
                                                                                                                if ($r['loyer_r'] != '') {

                                                                                                                    $decimLr = "0" . strstr($r['loyer_r'], '.');

                                                                                                                    if ($decimLr == 0) {
                                                                                                                        $loyerR = number_format($r['loyer_r'], 0, ',', ' ') . ' €';
                                                                                                                    } else {
                                                                                                                        $loyerR = number_format($r['loyer_r'], 2, ',', ' ') . ' €';
                                                                                                                    }
                                                                                                                } else {
                                                                                                                    $loyerR = '';
                                                                                                                }
                                                                                                                echo $loyerR; ?></td>
                                        <td id="acompte<?php echo $id; ?>" class="txtcenter arial bold"><?php echo str_replace('.', ',', $acompte); ?></td>
                                        <td id="solde<?php echo $id; ?>" class="txtcenter arial bold"><?php echo str_replace('.', ',', $solde); ?></td>
                                        <td id="channel<?php echo $id; ?>"><?php echo $channelName; ?></td>
                                        <td id="pub<?php echo $id; ?>"><?php echo $r['pub']; ?></td>
                                        <td class="flex resaTools white">
                                            <div class="editResa bggrey1 white tooltips" title="Modifier la réservation" data_id="<?php echo $r['id']; ?>">&#9998;</div>
                                            <div class="reject bggrey1 tooltips" title="Supprimer la réservation" data_id="<?php echo $r['id']; ?>"></div>
                                        </td>
                                    </tr>
                                <?php $statcss = '';
                                $i++;
                            } ?>
                                    </tbody>
                                </table>
        </div>
    </div>
    <script type="text/javascript">
        $("html,body").animate({
            scrollTop: 0
        }, 0);

        $('.addcal').click(function() {
            $.post("booking/valbook.php", $(this).closest("form").serialize(), function(response) {
                $('#visu').html(response);
            });
            return false;
        });

        $('.editResa').click(function() {
            var source = $(this).attr("data_id");
            $.post("booking/editbook.php", {
                rentID: source,
                form: 'editresa'
            }, function(data) {
                $('#visu').html(data);
            });
        });

        $('.annul').click(function() {
            var source = $(this).attr("data_id");
            if (confirm('Annuler cette réservation ?')) {
                $.post("delevent.php", {
                    id: source,
                    form: 'annulResa'
                }, function(response) {
                    $('#visu').html(response);
                });
            }
        });

        $('.reject').click(function() {
            var source = $(this).attr("data_id");
            if (confirm('Supprimer cette demande de réservation ?')) {
                $.post("delevent.php", {
                    id: source,
                    form: 'rejectResa'
                }, function(data) {
                    $('#visu').html(data);
                });
            }
        });

        $('.openMail').click(function() {
            var message = $(this).closest("form").find('.resaMess').text();
            var destin = $(this).closest("form").find('.replyTo').text();
            var dateResa = $(this).closest("form").find('input[name=resaDay]').val();

            window.location.href = "mailto:" + destin + "?subject=Demande de location" + "&body=" + message;
            $.post("mailing/addmess.php", {
                destin: destin,
                message: message,
                date: dateResa
            }, function(data) {
                $('#visu').html(data);
            });
        });

        $(document).ready(function() {
            new $.Zebra_Tooltips($('.tooltips'));
        });
    </script>
</div>