<?php
session_start();
include('../data/data.php');
setlocale(LC_TIME, 'fr_FR', 'fra');
error_reporting(E_ALL);
ini_set('display_errors', 'On');

function convertDate($date)
{
    $formatter = new IntlDateFormatter('fr_FR', IntlDateFormatter::LONG, IntlDateFormatter::NONE);
    $conv = date_create($date);
    return $formatter->format($conv);
}

function convertTS($ts)
{
    return date("Ymd", $ts);
}

function convertTSF($ts)
{
    return date("d/m/Y", $ts);
}
/* --------------  Connexion  -------------------- */

$user = '';
$pass = '';

if (!isset($_SESSION['maid'])) {
    if (isset($_COOKIE['login']) && isset($_COOKIE['pass'])) {
        $_SESSION['admin'] = 'maid';
    }
}
?>

<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8" />
    <title> <?php //echo $title;     
            ?> </title>
    <meta name="description" content="<?php //echo $content;     
                                        ?>" />
    <meta name="keywords" content="<?php //echo $key;     
                                    ?>" />
    <meta name="viewport" content="width=device-width">
    <!-- META FOR IOS & HANDHELD -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="HandheldFriendly" content="true" />
    <meta name="apple-touch-fullscreen" content="YES" />
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Frank+Ruhl+Libre|Noto+Sans" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/style.css" media="screen" />
    <link rel="stylesheet" type="text/css" href="<?php echo $domain; ?>css/admin.css?ver=<?php echo time(); ?>" media="screen" />
</head>

<body>
    <?php
    if (isset($_SESSION['maid']) && isset($_SESSION['log'])) {
    ?>
        <div id="page">
            <div id="adminhead" class="rel mb3 fs3 txtcenter bgc1 white">
                <p id="headerTitle" class="mt0 fs3">Réservations</p>
                <div id="logout" class="abs pointer bggrey3">
                    <a href="<?php echo $domain; ?>"><img src="../images/icones/logout.svg" /></a>
                </div>
            </div>
            <div id="content" class="w90 center">
                <div id="reservation" class="rel">
                    <div class="flex flexHcenter flexEven mb3">
                        <div id="colorState" class="flex flexBet flexCenter">
                            <div class="blg">Réservé</div>
                            <div class="bly">Optionné</div>
                            <div class="blb">Maintenance</div>
                        </div>
                        <div>
                            <a href="../print-list.php" target="_blank" class="abs w200p pa1 rad3 bggrey1 white"><img src="../images/icones/pdf.svg" class="pdf" /> Imprimer la liste </a>
                        </div>
                    </div>
                    <?php
                    $dayref = new DateTime("now");
                    $dayref = $dayref->modify('-1 day');
                    $today = $dayref->getTimestamp(); // Timestamp du jour + 1 jour

                    $year = '';
                    $month = '';
                    $newyear = 0;
                    $newmonth = 0;
                    $i = 0;

                    $query = $sql->run('SELECT property,rent,start,end,caution,firstname,lastname,phone,email,adult,child,accueil, statut FROM booking WHERE end>' . $today . ' AND statut IN(1,2,3) ORDER BY property ASC, start ASC, rent ASC');

                    while ($r = $query->fetch()) {

                        if ($i % 2 == 1) {
                            $css = 'bgf2';
                        } else {
                            $css = '';
                        }

                        $start = convertTSF($r['start']);
                        $end = convertTSF($r['end']);
                        $phone = chunk_split($r['phone'], 2, ' ');

                        $adult = 'adulte';
                        $child = 'enfant';

                        if ($r['adult'] > 1) {
                            $adult = 'adultes';
                        }

                        if ($r['child'] > 1) {
                            $child = 'enfants';
                        }

                        if ($year != date("Y", $r['start'])) {
                            if ($newyear != 0) {
                                echo '</td></tr></table>';
                            }
                            $year = date("Y", $r['start']);
                            $newyear = 1;
                    ?>
                            <h1 class="mt3 mb1 txtcenter cyan2"><?php echo $year; ?></h1>
                            <table class="w100 resa">
                                <tr>
                                    <td>
                                    <?php
                                }

                                $startMonth = convertTS($r['start']);
                                $startMonth = convertDate($startMonth);
                                $startMonth = preg_replace('/\d/', '', $startMonth);

                                if ($month != $startMonth) {
                                    if ($newmonth != '') {
                                        echo '</table>';
                                    }
                                    $month = $startMonth;
                                    ?>

                                        <table id="planningC" class="bookings w100 mb3">
                                            <thead>
                                                <tr class="rel white">
                                                    <th colspan="7" class="rel">
                                                        <div class="left bgrust w200p"><?php echo ucfirst(trim($month)) . ' ' . $year; ?></div>
                                                        <div class="left w350p pl3 pr3 bgorange"><?php echo $r['property']; ?></div>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr class="bggrey3 white">
                                                    <td class="w150p">Location</td>
                                                    <td class="w100p">Check In</td>
                                                    <td class="w100p">Check Out</td>
                                                    <td class="w200p">Locataire</td>
                                                    <td class="w200p">Contact</td>
                                                    <td class="w200p txtcenter">Caution</td>
                                                    <td class="txtcenter">Consignes</td>
                                                </tr>
                                            <?php }

                                        $color = '';

                                        switch ($r['statut']) {
                                            case 1:
                                                $color = 'bly';
                                                break;
                                            case 2:
                                                $color = 'blg';
                                                break;
                                            case 3:
                                                $color = 'blb';
                                                break;
                                        }
                                            ?>
                                            <tr>
                                                <td class="bold <?= $color ?>"><?php echo $r['rent']; ?></td>
                                                <td class="arial cyan2"><?php echo $start; ?></td>
                                                <td class="arial cyan2"><?php echo $end; ?></td>
                                                <td><span class="arial bold"><?php echo $r['firstname'] . ' ' . $r['lastname']; ?></span><br /><?php echo $r['adult'] . ' ' . $adult . ' + ' . $r['child'] . ' ' . $child; ?></td>
                                                <td><span class="arial bold"><?php echo $phone; ?></span><br /><?php echo $r['email']; ?></td>
                                                <td class="arial"><?php echo $r['caution']; ?></td>
                                                <td class="deskComment"><?php echo $r['accueil']; ?></td>
                                            </tr>
                                        <?php $i++;
                                    } ?>
                                            </tbody>
                                        </table>
                </div>
            </div>
            <script type="text/javascript">
                $("html,body").animate({
                    scrollTop: 0
                }, 0);
            </script>
        </div>
        </div>
        </div>
        <div id="visu"></div>
        <script type="text/javascript" src="<?php echo $domain; ?>js/jquery.js"></script>

        <script type="text/javascript">
            $(document).ready(function() {
                window.history.pushState(null, "", window.location.href);
                window.onpopstate = function() {
                    window.history.pushState(null, "", window.location.href);
                };

                function scrollToAnchor(aid) {
                    var aTag = $("a[name='" + aid + "']");
                    $('html,body').animate({
                        scrollTop: aTag.offset().top
                    }, 'slow');
                }

                $('#logout').click(function() {
                    $.get("logout.php", function(response) {
                        $('#visu').html(response);
                    });
                    return false;
                });
            });
        </script>
    <?php
    } else {
    ?>
        <script type="text/javascript" src="<?php echo $domain; ?>js/jquery.js"></script>
        <div id="adminhead" class="rel mb3 fs3 txtcenter watergreen white">
            <p id="headerTitle" class="mt0 fs3">SERRE CHEVALIER HOLIDAYS</p>
        </div>
        <div id="portail">
            <div id="bgLogin" class="pt2 polar">
                <form id="check" method="post" class="center txtcenter white">
                    <p class="mb2"><input type="text" name='login' id="log" placeholder=" Identifiant" class="w250p pl1" /></p>
                    <p class="pb2"><input type="password" name='pass' id="pass" placeholder=" Mot de passe" class="password w250p pl1" /><span id="showHide" class="voir"></span></p>
                    <div class="inbl">
                        <p id="subP" class="mt0 pl2 pr2 bggrey1 white pointer" />Valider</p>
                    </div>
                    <p class="field mt2"><input type="checkbox" name='cook' class="mr2" /> Se souvenir de moi</p>
                </form>
            </div>
        </div>
        <div id="result"></div>
        <script type="text/javascript">
            $("#showHide").click(function() {
                $(this).toggleClass("voir masquer");
                if ($(this).hasClass("voir")) {
                    $(".password").attr("type", "password");
                } else {
                    $(".password").attr("type", "text");
                }
            });

            $('#subP').click(function() {
                var login = $.trim($('#log').val());
                var pass = $.trim($('#pass').val());
                if (login === '' || pass === '') {} else {
                    $.post("control.php", $("#check").serialize(), function(response) {
                        $('#result').html(response);
                    });
                    return false;
                }
            });
        </script>
    <?php } ?>
</body>

</html>